/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.ArrayList;
import java.util.Map;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpInboundConnectionTest
extends AmqpClientTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpInboundConnectionTest.class);
    private static final String BROKER_NAME = "localhost";
    private static final String PRODUCT_NAME = "apache-activemq-artemis";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCloseIsSentOnConnectionClose() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection amqpConnection = client.connect();){
            for (RemotingConnection connection : this.server.getRemotingService().getConnections()) {
                this.server.getRemotingService().removeConnection((Object)connection);
                connection.disconnect(true);
            }
            Wait.assertTrue(() -> ((AmqpConnection)amqpConnection).isClosed());
            AmqpInboundConnectionTest.assertEquals((Object)AmqpSupport.CONNECTION_FORCED, (Object)amqpConnection.getConnection().getRemoteCondition().getCondition());
        }
    }

    @Test(timeout=60000L)
    public void testBrokerContainerId() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpInboundConnectionTest.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Connection connection) {
                if (!AmqpInboundConnectionTest.BROKER_NAME.equals(connection.getRemoteContainer())) {
                    this.markAsInvalid("Broker did not send the expected container ID");
                }
            }
        });
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpInboundConnectionTest.assertNotNull((Object)connection);
            connection.getStateInspector().assertValid();
        }
    }

    @Test(timeout=60000L)
    public void testDefaultMaxFrameSize() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpInboundConnectionTest.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Connection connection) {
                int brokerMaxFrameSize = connection.getTransport().getRemoteMaxFrameSize();
                if (brokerMaxFrameSize != 131072) {
                    this.markAsInvalid("Broker did not send the expected max Frame Size");
                }
            }
        });
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpInboundConnectionTest.assertNotNull((Object)connection);
            connection.getStateInspector().assertValid();
        }
    }

    @Test(timeout=60000L)
    public void testBrokerConnectionProperties() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Connection connection) {
                Map properties = connection.getRemoteProperties();
                if (!properties.containsKey(AmqpSupport.PRODUCT)) {
                    this.markAsInvalid("Broker did not send a queue product name value");
                    return;
                }
                if (!properties.containsKey(AmqpSupport.VERSION)) {
                    this.markAsInvalid("Broker did not send a queue version value");
                    return;
                }
                if (!AmqpInboundConnectionTest.PRODUCT_NAME.equals(properties.get(AmqpSupport.PRODUCT))) {
                    this.markAsInvalid("Broker did not send a the expected product name");
                    return;
                }
                String brokerVersion = VersionLoader.getVersion().getFullVersion();
                if (!brokerVersion.equals(properties.get(AmqpSupport.VERSION))) {
                    this.markAsInvalid("Broker did not send a the expected product version");
                    return;
                }
            }
        });
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpInboundConnectionTest.assertNotNull((Object)connection);
            connection.getStateInspector().assertValid();
        }
    }

    @Test(timeout=60000L)
    public void testConnectionCarriesExpectedCapabilities() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpInboundConnectionTest.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Connection connection) {
                Symbol[] offered = connection.getRemoteOfferedCapabilities();
                if (!AmqpSupport.contains((Symbol[])offered, (Symbol)AmqpSupport.ANONYMOUS_RELAY)) {
                    this.markAsInvalid("Broker did not indicate it support anonymous relay");
                    return;
                }
                if (!AmqpSupport.contains((Symbol[])offered, (Symbol)AmqpSupport.DELAYED_DELIVERY)) {
                    this.markAsInvalid("Broker did not indicate it support delayed message delivery");
                    return;
                }
            }
        });
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpInboundConnectionTest.assertNotNull((Object)connection);
            connection.getStateInspector().assertValid();
        }
    }

    @Test(timeout=60000L)
    public void testCanConnectWithDifferentContainerIds() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpInboundConnectionTest.assertNotNull((Object)client);
        AmqpConnection connection1 = this.addConnection(client.createConnection());
        AmqpConnection connection2 = this.addConnection(client.createConnection());
        connection1.setContainerId(this.getTestName() + "-Client:1");
        connection2.setContainerId(this.getTestName() + "-Client:2");
        connection1.connect();
        Wait.assertEquals((int)1, () -> ((ActiveMQServer)this.server).getConnectionCount());
        connection2.connect();
        Wait.assertEquals((int)2, () -> ((ActiveMQServer)this.server).getConnectionCount());
        connection1.close();
        Wait.assertEquals((int)1, () -> ((ActiveMQServer)this.server).getConnectionCount());
        connection2.close();
        Wait.assertEquals((int)0, () -> ((ActiveMQServer)this.server).getConnectionCount());
    }

    @Test(timeout=60000L)
    public void testCannotConnectWithSameContainerId() throws Exception {
        AmqpClient client = this.createAmqpClient();
        ArrayList<Symbol> desiredCapabilities = new ArrayList<Symbol>(1);
        desiredCapabilities.add(AmqpSupport.SOLE_CONNECTION_CAPABILITY);
        AmqpInboundConnectionTest.assertNotNull((Object)client);
        AmqpConnection connection1 = this.addConnection(client.createConnection());
        AmqpConnection connection2 = this.addConnection(client.createConnection());
        connection1.setDesiredCapabilities(desiredCapabilities);
        connection2.setDesiredCapabilities(desiredCapabilities);
        connection1.setContainerId(this.getTestName());
        connection2.setContainerId(this.getTestName());
        connection1.connect();
        AmqpInboundConnectionTest.assertEquals((long)1L, (long)this.server.getConnectionCount());
        connection2.setStateInspector(new AmqpValidator(){

            public void inspectOpenedResource(Connection connection) {
                if (!connection.getRemoteProperties().containsKey(AmqpSupport.CONNECTION_OPEN_FAILED)) {
                    this.markAsInvalid("Broker did not set connection establishment failed property");
                }
            }

            public void inspectClosedResource(Connection connection) {
                ErrorCondition remoteError = connection.getRemoteCondition();
                if (remoteError == null || remoteError.getCondition() == null) {
                    this.markAsInvalid("Broker did not add error condition for duplicate client ID");
                } else {
                    if (!remoteError.getCondition().equals(AmqpError.INVALID_FIELD)) {
                        this.markAsInvalid("Broker did not set condition to " + AmqpError.INVALID_FIELD);
                    }
                    if (!remoteError.getCondition().equals(AmqpError.INVALID_FIELD)) {
                        this.markAsInvalid("Broker did not set condition to " + AmqpError.INVALID_FIELD);
                    }
                }
                Map infoMap = remoteError.getInfo();
                if (infoMap == null) {
                    this.markAsInvalid("Broker did not set an info map on condition");
                } else if (!infoMap.containsKey(AmqpSupport.INVALID_FIELD)) {
                    this.markAsInvalid("Info map does not contain expected key");
                } else {
                    Object value = infoMap.get(AmqpSupport.INVALID_FIELD);
                    if (!AmqpSupport.CONTAINER_ID.equals(value)) {
                        this.markAsInvalid("Info map does not contain expected value: " + value);
                    }
                }
            }
        });
        try {
            connection2.connect();
            AmqpInboundConnectionTest.fail((String)"Should not be able to connect with same container Id.");
        }
        catch (Exception ex) {
            LOG.debug("Second connection with same container Id failed as expected.");
        }
        connection2.getStateInspector().assertValid();
        connection2.close();
        Wait.assertEquals((int)1, () -> ((ActiveMQServer)this.server).getConnectionCount());
        connection1.close();
        Wait.assertEquals((int)0, () -> ((ActiveMQServer)this.server).getConnectionCount());
    }
}

