/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.integration.amqp.largemessages.AMQPLargeMessagesTestUtil;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AmqpBridgeClusterRedistributionTest
extends AmqpClientTestSupport {
    protected ActiveMQServer[] servers = new ActiveMQServer[3];
    private ActiveMQServer server0;
    private ActiveMQServer server1;
    private ActiveMQServer server2;
    private SimpleString customNotificationQueue;
    private SimpleString frameworkNotificationsQueue;
    private SimpleString bridgeNotificationsQueue;
    private SimpleString notificationsQueue;

    protected String getServer0URL() {
        return "tcp://localhost:61616";
    }

    protected String getServer1URL() {
        return "tcp://localhost:61617";
    }

    protected String getServer2URL() {
        return "tcp://localhost:61618";
    }

    @Override
    public URI getBrokerAmqpConnectionURI() {
        try {
            return new URI(this.getServer0URL());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize, Map<String, AddressSettings> settings) {
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)realFiles));
        if (settings != null) {
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
        }
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(pageSize).setMaxSizeBytes(maxAddressSize).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setRedeliveryDelay(0L).setRedistributionDelay(0L).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true));
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        return server;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server0 = this.createServer(true, (Configuration)this.createBasicConfig(0));
        this.server1 = this.createServer(true, (Configuration)this.createBasicConfig(1));
        this.server2 = this.createServer(true, (Configuration)this.createBasicConfig(2));
        this.servers[0] = this.server0;
        this.servers[1] = this.server1;
        this.servers[2] = this.server2;
        this.server0.getConfiguration().addAcceptorConfiguration("acceptor", this.getServer0URL());
        this.server0.getConfiguration().addConnectorConfiguration("notification-broker", this.getServer1URL());
        this.server1.getConfiguration().addAcceptorConfiguration("acceptor", this.getServer1URL());
        this.server2.getConfiguration().addAcceptorConfiguration("acceptor", this.getServer2URL());
        DivertConfiguration customNotificationsDivert = new DivertConfiguration().setName("custom-notifications-divert").setAddress("*.Provider.*.Agent.*.CustomNotification").setForwardingAddress("FrameworkNotifications").setExclusive(true);
        DivertConfiguration frameworkNotificationsDivertServer1 = new DivertConfiguration().setName("framework-notifications-divert").setAddress("BridgeNotifications").setForwardingAddress("Notifications").setRoutingType(ComponentConfigurationRoutingType.MULTICAST).setExclusive(true);
        DivertConfiguration frameworkNotificationsDivertServer2 = new DivertConfiguration().setName("framework-notifications-divert").setAddress("BridgeNotifications").setForwardingAddress("Notifications").setRoutingType(ComponentConfigurationRoutingType.MULTICAST).setExclusive(true);
        this.server0.getConfiguration().addDivertConfiguration(customNotificationsDivert);
        this.server1.getConfiguration().addDivertConfiguration(frameworkNotificationsDivertServer1);
        this.server2.getConfiguration().addDivertConfiguration(frameworkNotificationsDivertServer2);
        this.customNotificationQueue = SimpleString.toSimpleString((String)"*.Provider.*.Agent.*.CustomNotification");
        this.frameworkNotificationsQueue = SimpleString.toSimpleString((String)"FrameworkNotifications");
        this.bridgeNotificationsQueue = SimpleString.toSimpleString((String)"BridgeNotifications");
        this.notificationsQueue = SimpleString.toSimpleString((String)"Notifications");
        this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.ON_DEMAND, 1, true, 1, 2);
        this.setupClusterConnection("cluster1", "", MessageLoadBalancingType.ON_DEMAND, 1, true, 2, 1);
        this.server0.start();
        this.server1.start();
        this.server2.start();
        this.server0.createQueue(new QueueConfiguration(this.customNotificationQueue).setRoutingType(RoutingType.ANYCAST));
        this.server0.createQueue(new QueueConfiguration(this.frameworkNotificationsQueue).setRoutingType(RoutingType.ANYCAST));
        this.server1.createQueue(new QueueConfiguration(this.bridgeNotificationsQueue).setRoutingType(RoutingType.ANYCAST));
        this.server1.createQueue(new QueueConfiguration(this.notificationsQueue));
        this.server2.createQueue(new QueueConfiguration(this.bridgeNotificationsQueue).setRoutingType(RoutingType.ANYCAST));
        this.server2.createQueue(new QueueConfiguration(this.notificationsQueue));
        this.server0.deployBridge(new BridgeConfiguration().setName("notifications-bridge").setQueueName(this.frameworkNotificationsQueue.toString()).setForwardingAddress(this.bridgeNotificationsQueue.toString()).setConfirmationWindowSize(10).setStaticConnectors(Arrays.asList("notification-broker")));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            if (this.server0 != null) {
                this.server0.stop();
            }
            if (this.server1 != null) {
                this.server1.stop();
            }
            if (this.server2 != null) {
                this.server2.stop();
            }
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testSendMessageToBroker0GetFromBroker1() throws Exception {
        try (ServerLocator locator = ActiveMQClient.createServerLocator((String)this.getServer1URL());
             ClientSessionFactory sessionFactory = locator.createSessionFactory();
             ClientSession session = sessionFactory.createSession();
             ClientConsumer consumer = session.createConsumer(this.notificationsQueue);){
            session.start();
            this.sendMessages("uswest.Provider.AMC.Agent.DIVERTED.CustomNotification", 1, RoutingType.ANYCAST, true);
            AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(this.server0);
            AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(this.server1);
            ClientMessage message = consumer.receive(5000L);
            AmqpBridgeClusterRedistributionTest.assertNotNull((Object)message);
            message = consumer.receiveImmediate();
            AmqpBridgeClusterRedistributionTest.assertNull((Object)message);
        }
        AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(this.server0);
        AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(this.server1);
    }

    @Test
    public void testSendMessageToBroker0GetFromBroker2() throws Exception {
        try (ServerLocator locator = ActiveMQClient.createServerLocator((String)this.getServer2URL());
             ClientSessionFactory sessionFactory = locator.createSessionFactory();
             ClientSession session = sessionFactory.createSession();
             ClientConsumer consumer = session.createConsumer(this.notificationsQueue);){
            session.start();
            this.sendMessages("uswest.Provider.AMC.Agent.DIVERTED.CustomNotification", 1, RoutingType.ANYCAST, true);
            AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(this.server0);
            AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(this.server1);
            ClientMessage message = consumer.receive(5000L);
            AmqpBridgeClusterRedistributionTest.assertNotNull((Object)message);
            message = consumer.receiveImmediate();
            AmqpBridgeClusterRedistributionTest.assertNull((Object)message);
        }
        AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(this.server0);
        AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(this.server1);
    }

    protected void setupClusterConnection(String name, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, boolean netty, int nodeFrom, int ... nodesTo) {
        this.setupClusterConnection(name, address, messageLoadBalancingType, maxHops, netty, null, nodeFrom, nodesTo);
    }

    protected void setupClusterConnection(String name, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, boolean netty, ClusterTestBase.ClusterConfigCallback cb, int nodeFrom, int ... nodesTo) {
        ActiveMQServer serverFrom = this.servers[nodeFrom];
        if (serverFrom == null) {
            throw new IllegalStateException("No server at node " + nodeFrom);
        }
        TransportConfiguration connectorFrom = AmqpBridgeClusterRedistributionTest.createTransportConfiguration((boolean)netty, (boolean)false, (Map)AmqpBridgeClusterRedistributionTest.generateParams((int)nodeFrom, (boolean)netty));
        serverFrom.getConfiguration().getConnectorConfigurations().put(connectorFrom.getName(), connectorFrom);
        List<String> pairs = this.getClusterConnectionTCNames(netty, serverFrom, nodesTo);
        Configuration config = serverFrom.getConfiguration();
        ClusterConnectionConfiguration clusterConf = this.createClusterConfig(name, address, messageLoadBalancingType, maxHops, connectorFrom, pairs);
        if (cb != null) {
            cb.configure(clusterConf);
        }
        config.getClusterConfigurations().add(clusterConf);
    }

    private List<String> getClusterConnectionTCNames(boolean netty, ActiveMQServer serverFrom, int[] nodesTo) {
        ArrayList<String> pairs = new ArrayList<String>();
        for (int element : nodesTo) {
            TransportConfiguration serverTotc = AmqpBridgeClusterRedistributionTest.createTransportConfiguration((boolean)netty, (boolean)false, (Map)AmqpBridgeClusterRedistributionTest.generateParams((int)element, (boolean)netty));
            serverFrom.getConfiguration().getConnectorConfigurations().put(serverTotc.getName(), serverTotc);
            pairs.add(serverTotc.getName());
        }
        return pairs;
    }

    private ClusterConnectionConfiguration createClusterConfig(String name, String address, MessageLoadBalancingType messageLoadBalancingType, int maxHops, TransportConfiguration connectorFrom, List<String> pairs) {
        return new ClusterConnectionConfiguration().setName(name).setAddress(address).setConnectorName(connectorFrom.getName()).setRetryInterval(250L).setMessageLoadBalancingType(messageLoadBalancingType).setMaxHops(maxHops).setConfirmationWindowSize(1024).setStaticConnectors(pairs);
    }
}

