/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class UniOnNotNull<T> {
    private final Uni<T> upstream;

    public UniOnNotNull(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(Consumer<? super T> callback) {
        Consumer actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return this.upstream.onItem().invoke((? super T item) -> {
            if (item != null) {
                actual.accept(item);
            }
        });
    }

    public Uni<T> invoke(Runnable callback) {
        Runnable runnable = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((? super T x) -> runnable.run());
    }

    public Uni<T> call(Function<? super T, Uni<?>> action) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.upstream.onItem().call((? super T item) -> {
            if (item != null) {
                return (Uni)actual.apply(item);
            }
            return Uni.createFrom().nullItem();
        });
    }

    public Uni<T> call(Supplier<Uni<?>> action) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.call((? super T ignored) -> (Uni)actual.get());
    }

    public <R> Uni<R> transform(Function<? super T, ? extends R> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return this.upstream.onItem().transform(item -> {
            if (item != null) {
                return actual.apply(item);
            }
            return null;
        });
    }

    public <R> Uni<R> transformToUni(Function<? super T, Uni<? extends R>> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return this.upstream.onItem().transformToUni((? super T item) -> {
            if (item != null) {
                return (Uni)actual.apply(item);
            }
            return Uni.createFrom().nullItem();
        });
    }

    public <R> Multi<R> transformToMulti(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return this.upstream.onItem().transformToMulti(item -> {
            if (item != null) {
                return (Publisher)actual.apply(item);
            }
            return Multi.createFrom().empty();
        });
    }

    public <R> Uni<R> transformToUni(BiConsumer<? super T, UniEmitter<? super R>> consumer) {
        BiConsumer actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return this.upstream.onItem().transformToUni((? super T item, UniEmitter<? super R> emitter) -> {
            if (item != null) {
                actual.accept((Object)item, (UniEmitter)emitter);
            } else {
                emitter.complete(null);
            }
        });
    }
}

