/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.infinispan.session.AbstractInfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaDataFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;

public class LockOnReadInfinispanSessionMetaDataFactory<L>
extends AbstractInfinispanSessionMetaDataFactory<L> {
    private final Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache;
    private final Cache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;

    public LockOnReadInfinispanSessionMetaDataFactory(InfinispanSessionMetaDataFactoryConfiguration configuration) {
        super(configuration);
        Cache creationMetaDataCache = configuration.getCache();
        this.creationMetaDataCache = creationMetaDataCache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK);
        this.accessMetaDataCache = configuration.getCache();
    }

    @Override
    public CompositeSessionMetaDataEntry<L> apply(String id, Set<Flag> flags) {
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)this.creationMetaDataCache.getAdvancedCache().withFlags(flags).get((Object)new SessionCreationMetaDataKey(id));
        if (creationMetaDataEntry != null) {
            SessionAccessMetaData accessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.get((Object)new SessionAccessMetaDataKey(id));
            if (accessMetaData != null) {
                return new CompositeSessionMetaDataEntry(creationMetaDataEntry, accessMetaData);
            }
            if (flags.isEmpty()) {
                this.purge(id);
            }
        }
        return null;
    }
}

