/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.jboss.as.connector.metadata.common.CredentialImpl;
import org.jboss.as.connector.metadata.common.SecurityImpl;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterActivatorService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.Activationspec;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.CredentialInterfaceEnum;
import org.jboss.jca.common.api.metadata.spec.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.Messageadapter;
import org.jboss.jca.common.api.metadata.spec.OutboundResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.PoolImpl;
import org.jboss.jca.common.metadata.common.TimeOutImpl;
import org.jboss.jca.common.metadata.common.ValidationImpl;
import org.jboss.jca.common.metadata.common.XaPoolImpl;
import org.jboss.jca.common.metadata.resourceadapter.ActivationImpl;
import org.jboss.jca.common.metadata.spec.ActivationSpecImpl;
import org.jboss.jca.common.metadata.spec.AuthenticationMechanismImpl;
import org.jboss.jca.common.metadata.spec.ConfigPropertyImpl;
import org.jboss.jca.common.metadata.spec.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.spec.ConnectorImpl;
import org.jboss.jca.common.metadata.spec.InboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.MessageAdapterImpl;
import org.jboss.jca.common.metadata.spec.MessageListenerImpl;
import org.jboss.jca.common.metadata.spec.OutboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.spec.RequiredConfigPropertyImpl;
import org.jboss.jca.common.metadata.spec.ResourceAdapterImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.spi.ClusteringDefaultRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.dispatcher.CommandDispatcherFactory;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.messaging.activemq.ActiveMQResourceAdapter;
import org.wildfly.extension.messaging.activemq.ExternalBrokerConfigurationService;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.JGroupsDiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.SocketDiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.broadcast.CommandDispatcherBroadcastEndpointFactory;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigProperties;
import org.wildfly.extension.messaging.activemq.jms.WildFlyRecoveryRegistry;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

public class ExternalPooledConnectionFactoryService
implements Service<ExternalPooledConnectionFactoryService> {
    private static final ServiceName JBOSS_MESSAGING_ACTIVEMQ = ServiceName.JBOSS.append(new String[]{"messaging-activemq"});
    private static final List<LocalizedXsdString> EMPTY_LOCL = Collections.emptyList();
    public static final String CONNECTOR_CLASSNAME = "connectorClassName";
    public static final String CONNECTION_PARAMETERS = "connectionParameters";
    private static final String ACTIVEMQ_ACTIVATION = "org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec";
    private static final String ACTIVEMQ_CONN_DEF = "ActiveMQConnectionDefinition";
    private static final String ACTIVEMQ_RESOURCE_ADAPTER = ActiveMQResourceAdapter.class.getName();
    private static final String RAMANAGED_CONN_FACTORY = "org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory";
    private static final String RA_CONN_FACTORY = "org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory";
    private static final String RA_CONN_FACTORY_IMPL = "org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl";
    private static final String JMS_SESSION = "jakarta.jms.Session";
    private static final String ACTIVEMQ_RA_SESSION = "org.apache.activemq.artemis.ra.ActiveMQRASession";
    private static final String BASIC_PASS = "BasicPassword";
    private static final String JMS_QUEUE = "jakarta.jms.Queue";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String INTEGER_TYPE = "java.lang.Integer";
    private static final String LONG_TYPE = "java.lang.Long";
    private static final String SESSION_DEFAULT_TYPE = "SessionDefaultType";
    private static final String TRY_LOCK = "UseTryLock";
    private static final String JMS_MESSAGE_LISTENER = "jakarta.jms.MessageListener";
    private static final String DEFAULT_MAX_RECONNECTS = "5";
    public static final String GROUP_ADDRESS = "discoveryAddress";
    public static final String DISCOVERY_INITIAL_WAIT_TIMEOUT = "discoveryInitialWaitTimeout";
    public static final String GROUP_PORT = "discoveryPort";
    public static final String REFRESH_TIMEOUT = "discoveryRefreshTimeout";
    public static final String DISCOVERY_LOCAL_BIND_ADDRESS = "discoveryLocalBindAddress";
    public static final String JGROUPS_CHANNEL_LOCATOR_CLASS = "jgroupsChannelLocatorClass";
    public static final String JGROUPS_CHANNEL_NAME = "jgroupsChannelName";
    public static final String JGROUPS_CHANNEL_REF_NAME = "jgroupsChannelRefName";
    private final DiscoveryGroupConfiguration discoveryGroupConfiguration;
    private final TransportConfiguration[] connectors;
    private List<PooledConnectionFactoryConfigProperties> adapterParams;
    private String name;
    private final Map<String, Supplier<SocketBinding>> socketBindings = new HashMap<String, Supplier<SocketBinding>>();
    private final Map<String, Supplier<OutboundSocketBinding>> outboundSocketBindings = new HashMap<String, Supplier<OutboundSocketBinding>>();
    private Map<String, Supplier<SocketBinding>> groupBindings = new HashMap<String, Supplier<SocketBinding>>();
    private final Map<String, String> clusterNames = new HashMap<String, String>();
    private final Map<String, Supplier<CommandDispatcherFactory>> commandDispatcherFactories = new HashMap<String, Supplier<CommandDispatcherFactory>>();
    private ContextNames.BindInfo bindInfo;
    private List<String> jndiAliases;
    private String txSupport;
    private int minPoolSize;
    private int maxPoolSize;
    private final String jgroupsClusterName;
    private final String jgroupsChannelName;
    private final String managedConnectionPoolClassName;
    private final Boolean enlistmentTrace;
    private ExceptionSupplier<CredentialSource, Exception> credentialSourceSupplier;
    private final boolean createBinderService;
    private final CapabilityServiceSupport capabilityServiceSupport;

    public ExternalPooledConnectionFactoryService(String name, TransportConfiguration[] connectors, DiscoveryGroupConfiguration groupConfiguration, String jgroupsClusterName, String jgroupsChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, ContextNames.BindInfo bindInfo, List<String> jndiAliases, String txSupport, int minPoolSize, int maxPoolSize, String managedConnectionPoolClassName, Boolean enlistmentTrace, CapabilityServiceSupport capabilityServiceSupport, boolean createBinderService) {
        this.name = name;
        this.connectors = connectors;
        this.discoveryGroupConfiguration = groupConfiguration;
        this.jgroupsClusterName = jgroupsClusterName;
        this.jgroupsChannelName = jgroupsChannelName;
        this.adapterParams = adapterParams;
        this.bindInfo = bindInfo;
        this.jndiAliases = new ArrayList<String>(jndiAliases);
        this.createBinderService = createBinderService;
        this.txSupport = txSupport;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.managedConnectionPoolClassName = managedConnectionPoolClassName;
        this.enlistmentTrace = enlistmentTrace;
        this.capabilityServiceSupport = capabilityServiceSupport;
    }

    public TransportConfiguration[] getConnectors() {
        return Arrays.copyOf(this.connectors, this.connectors.length);
    }

    public ContextNames.BindInfo getBindInfo() {
        return this.bindInfo;
    }

    static ServiceName getResourceAdapterActivatorsServiceName(String name) {
        return ConnectorServices.RESOURCE_ADAPTER_ACTIVATOR_SERVICE.append(new String[]{name});
    }

    public static ExternalPooledConnectionFactoryService installService(ServiceTarget serviceTarget, ExternalBrokerConfigurationService configuration, String name, TransportConfiguration[] connectors, DiscoveryGroupConfiguration groupConfiguration, Set<String> connectorsSocketBindings, String jgroupClusterName, String jgroupChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, ContextNames.BindInfo bindInfo, List<String> jndiAliases, String txSupport, int minPoolSize, int maxPoolSize, String managedConnectionPoolClassName, Boolean enlistmentTrace, CapabilityServiceSupport capabilityServiceSupport) throws OperationFailedException {
        ServiceName serviceName = JMSServices.getPooledConnectionFactoryBaseServiceName(JBOSS_MESSAGING_ACTIVEMQ).append(new String[]{name});
        ExternalPooledConnectionFactoryService service = new ExternalPooledConnectionFactoryService(name, connectors, groupConfiguration, jgroupClusterName, jgroupChannelName, adapterParams, bindInfo, jndiAliases, txSupport, minPoolSize, maxPoolSize, managedConnectionPoolClassName, enlistmentTrace, capabilityServiceSupport, false);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName);
        ExternalPooledConnectionFactoryService.installService0(serviceBuilder, configuration, service, groupConfiguration, connectorsSocketBindings, capabilityServiceSupport);
        return service;
    }

    public static ExternalPooledConnectionFactoryService installService(OperationContext context, String name, TransportConfiguration[] connectors, DiscoveryGroupConfiguration groupConfiguration, Set<String> connectorsSocketBindings, String jgroupClusterName, String jgroupChannelName, List<PooledConnectionFactoryConfigProperties> adapterParams, ContextNames.BindInfo bindInfo, List<String> jndiAliases, String txSupport, int minPoolSize, int maxPoolSize, String managedConnectionPoolClassName, Boolean enlistmentTrace, ModelNode model) throws OperationFailedException {
        ServiceName serviceName = JMSServices.getPooledConnectionFactoryBaseServiceName(JBOSS_MESSAGING_ACTIVEMQ).append(new String[]{name});
        ExternalPooledConnectionFactoryService service = new ExternalPooledConnectionFactoryService(name, connectors, groupConfiguration, jgroupClusterName, jgroupChannelName, adapterParams, bindInfo, jndiAliases, txSupport, minPoolSize, maxPoolSize, managedConnectionPoolClassName, enlistmentTrace, context.getCapabilityServiceSupport(), true);
        ExternalPooledConnectionFactoryService.installService0(context, serviceName, service, groupConfiguration, connectorsSocketBindings, model);
        return service;
    }

    private static void installService0(OperationContext context, ServiceName serviceName, ExternalPooledConnectionFactoryService service, DiscoveryGroupConfiguration groupConfiguration, Set<String> connectorsSocketBindings, ModelNode model) throws OperationFailedException {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName);
        serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.transactions.global-default-local-provider", null));
        serviceBuilder.requires(MessagingServices.ACTIVEMQ_CLIENT_THREAD_POOL);
        ModelNode credentialReference = ConnectionFactoryAttributes.Pooled.CREDENTIAL_REFERENCE.resolveModelAttribute(context, model);
        if (credentialReference.isDefined()) {
            service.credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)ConnectionFactoryAttributes.Pooled.CREDENTIAL_REFERENCE, (ModelNode)model, (ServiceBuilder)serviceBuilder);
        }
        Map<String, Boolean> outbounds = TransportConfigOperationHandlers.listOutBoundSocketBinding(context, connectorsSocketBindings);
        for (String connectorSocketBinding : connectorsSocketBindings) {
            if (outbounds.get(connectorSocketBinding).booleanValue()) {
                ServiceName outboundSocketName = OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{connectorSocketBinding});
                Supplier outboundSocketBindingSupplier = serviceBuilder.requires(outboundSocketName);
                service.outboundSocketBindings.put(connectorSocketBinding, outboundSocketBindingSupplier);
                continue;
            }
            ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{connectorSocketBinding});
            Supplier socketBindingSupplier = serviceBuilder.requires(socketName);
            service.socketBindings.put(connectorSocketBinding, socketBindingSupplier);
        }
        if (groupConfiguration != null) {
            String key = "discovery" + groupConfiguration.getName();
            if (service.jgroupsClusterName != null) {
                ServiceName commandDispatcherFactoryServiceName = service.jgroupsChannelName != null ? ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context, service.jgroupsChannelName) : ClusteringDefaultRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context);
                Supplier commandDispatcherFactorySupplier = serviceBuilder.requires(commandDispatcherFactoryServiceName);
                service.commandDispatcherFactories.put(key, commandDispatcherFactorySupplier);
                service.clusterNames.put(key, service.jgroupsClusterName);
            } else {
                ServiceName groupBinding = GroupBindingService.getDiscoveryBaseServiceName(JBOSS_MESSAGING_ACTIVEMQ).append(new String[]{groupConfiguration.getName()});
                Supplier socketBindingSupplier = serviceBuilder.requires(groupBinding);
                service.groupBindings.put(key, socketBindingSupplier);
            }
        }
        serviceBuilder.setInstance((org.jboss.msc.Service)service);
        serviceBuilder.install();
    }

    private static void installService0(ServiceBuilder serviceBuilder, ExternalBrokerConfigurationService configuration, ExternalPooledConnectionFactoryService service, DiscoveryGroupConfiguration groupConfiguration, Set<String> connectorsSocketBindings, CapabilityServiceSupport capabilityServiceSupport) throws OperationFailedException {
        serviceBuilder.requires(capabilityServiceSupport.getCapabilityServiceName("org.wildfly.transactions.global-default-local-provider"));
        serviceBuilder.requires(MessagingServices.ACTIVEMQ_CLIENT_THREAD_POOL);
        Map<String, ServiceName> outbounds = configuration.getOutboundSocketBindings();
        for (String connectorSocketBinding : connectorsSocketBindings) {
            if (outbounds.containsKey(connectorSocketBinding)) {
                Supplier outboundSocketBindingSupplier = serviceBuilder.requires(configuration.getOutboundSocketBindings().get(connectorSocketBinding));
                service.outboundSocketBindings.put(connectorSocketBinding, outboundSocketBindingSupplier);
                continue;
            }
            Supplier socketBindingSupplier = serviceBuilder.requires(configuration.getSocketBindings().get(connectorSocketBinding));
            service.socketBindings.put(connectorSocketBinding, socketBindingSupplier);
        }
        if (groupConfiguration != null) {
            String key = "discovery" + groupConfiguration.getName();
            if (service.jgroupsClusterName != null) {
                Supplier commandDispatcherFactorySupplier = serviceBuilder.requires(configuration.getCommandDispatcherFactories().get(key));
                service.commandDispatcherFactories.put(key, commandDispatcherFactorySupplier);
                service.clusterNames.put(key, service.jgroupsClusterName);
            } else {
                Supplier socketBindingSupplier = serviceBuilder.requires(configuration.getGroupBindings().get(key));
                service.groupBindings.put(key, socketBindingSupplier);
            }
        }
        serviceBuilder.setInstance((org.jboss.msc.Service)service);
        serviceBuilder.install();
    }

    public ExternalPooledConnectionFactoryService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ServiceTarget serviceTarget = context.getChildTarget();
        try {
            this.createService(serviceTarget, context.getController().getServiceContainer());
        }
        catch (Exception e) {
            throw MessagingLogger.ROOT_LOGGER.failedToCreate((Throwable)e, "resource adapter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createService(ServiceTarget serviceTarget, ServiceContainer container) throws Exception {
        InputStream is = null;
        InputStream isIj = null;
        ArrayList<ConfigProperty> properties = new ArrayList<ConfigProperty>();
        try {
            StringBuilder connectorClassname = new StringBuilder();
            StringBuilder connectorParams = new StringBuilder();
            TransportConfigOperationHandlers.processConnectorBindings(Arrays.asList(this.connectors), this.socketBindings, this.outboundSocketBindings);
            for (TransportConfiguration tc : this.connectors) {
                if (tc == null) {
                    throw MessagingLogger.ROOT_LOGGER.connectorNotDefined(tc.getName());
                }
                if (connectorClassname.length() > 0) {
                    connectorClassname.append(",");
                    connectorParams.append(",");
                }
                connectorClassname.append(tc.getFactoryClassName());
                Map params = tc.getParams();
                boolean multiple = false;
                for (Map.Entry entry : params.entrySet()) {
                    if (multiple) {
                        connectorParams.append(";");
                    }
                    connectorParams.append((String)entry.getKey()).append("=").append(entry.getValue());
                    multiple = true;
                }
            }
            if (connectorClassname.length() > 0) {
                properties.add(ExternalPooledConnectionFactoryService.simpleProperty15(CONNECTOR_CLASSNAME, STRING_TYPE, connectorClassname.toString()));
            }
            if (connectorParams.length() > 0) {
                properties.add(ExternalPooledConnectionFactoryService.simpleProperty15(CONNECTION_PARAMETERS, STRING_TYPE, connectorParams.toString()));
            }
            if (this.discoveryGroupConfiguration != null) {
                DiscoveryGroupConfiguration config;
                String dgName = this.discoveryGroupConfiguration.getName();
                String key = "discovery" + dgName;
                if (this.commandDispatcherFactories.containsKey(key)) {
                    CommandDispatcherFactory commandDispatcherFactory = this.commandDispatcherFactories.get(key).get();
                    String clusterName = this.clusterNames.get(key);
                    config = JGroupsDiscoveryGroupAdd.createDiscoveryGroupConfiguration(this.name, this.discoveryGroupConfiguration, commandDispatcherFactory, clusterName);
                } else {
                    SocketBinding binding = this.groupBindings.get(key).get();
                    if (binding == null) {
                        throw MessagingLogger.ROOT_LOGGER.failedToFindDiscoverySocketBinding(dgName);
                    }
                    config = SocketDiscoveryGroupAdd.createDiscoveryGroupConfiguration(this.name, this.discoveryGroupConfiguration, binding);
                    binding.getSocketBindings().getNamedRegistry().registerBinding(ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)binding));
                }
                BroadcastEndpointFactory bgCfg = config.getBroadcastEndpointFactory();
                if (bgCfg instanceof UDPBroadcastEndpointFactory) {
                    UDPBroadcastEndpointFactory udpCfg = (UDPBroadcastEndpointFactory)bgCfg;
                    properties.add(ExternalPooledConnectionFactoryService.simpleProperty15(GROUP_ADDRESS, STRING_TYPE, udpCfg.getGroupAddress()));
                    properties.add(ExternalPooledConnectionFactoryService.simpleProperty15(GROUP_PORT, INTEGER_TYPE, "" + udpCfg.getGroupPort()));
                    properties.add(ExternalPooledConnectionFactoryService.simpleProperty15(DISCOVERY_LOCAL_BIND_ADDRESS, STRING_TYPE, "" + udpCfg.getLocalBindAddress()));
                } else if (bgCfg instanceof CommandDispatcherBroadcastEndpointFactory) {
                    String external = "/" + this.name + ":discovery" + dgName;
                    properties.add(ExternalPooledConnectionFactoryService.simpleProperty15(JGROUPS_CHANNEL_NAME, STRING_TYPE, this.jgroupsClusterName));
                    properties.add(ExternalPooledConnectionFactoryService.simpleProperty15(JGROUPS_CHANNEL_REF_NAME, STRING_TYPE, external));
                }
                properties.add(ExternalPooledConnectionFactoryService.simpleProperty15(DISCOVERY_INITIAL_WAIT_TIMEOUT, LONG_TYPE, "" + config.getDiscoveryInitialWaitTimeout()));
                properties.add(ExternalPooledConnectionFactoryService.simpleProperty15(REFRESH_TIMEOUT, LONG_TYPE, "" + config.getRefreshTimeout()));
            }
            boolean hasReconnect = false;
            ArrayList<ConfigProperty> inboundProperties = new ArrayList<ConfigProperty>();
            ArrayList<ConfigProperty> outboundProperties = new ArrayList<ConfigProperty>();
            String reconnectName = "reconnectAttempts";
            block9: for (PooledConnectionFactoryConfigProperties adapterParam : this.adapterParams) {
                hasReconnect |= "reconnectAttempts".equals(adapterParam.getName());
                ConfigProperty p = ExternalPooledConnectionFactoryService.simpleProperty15(adapterParam.getName(), adapterParam.getType(), adapterParam.getValue());
                if (adapterParam.getName().equals("rebalanceConnections")) {
                    boolean rebalanceConnections = Boolean.parseBoolean(adapterParam.getValue());
                    if (!rebalanceConnections) continue;
                    inboundProperties.add(p);
                    continue;
                }
                if (null == adapterParam.getConfigType()) {
                    properties.add(p);
                    continue;
                }
                switch (adapterParam.getConfigType()) {
                    case INBOUND: {
                        inboundProperties.add(p);
                        continue block9;
                    }
                    case OUTBOUND: {
                        outboundProperties.add(p);
                        continue block9;
                    }
                }
                properties.add(p);
            }
            if (!hasReconnect) {
                properties.add(ExternalPooledConnectionFactoryService.simpleProperty15("reconnectAttempts", Integer.class.getName(), DEFAULT_MAX_RECONNECTS));
            }
            this.configureCredential(properties);
            WildFlyRecoveryRegistry.container = container;
            OutboundResourceAdapter outbound = ExternalPooledConnectionFactoryService.createOutbound(outboundProperties);
            InboundResourceAdapter inbound = this.createInbound(inboundProperties);
            ResourceAdapter ra = this.createResourceAdapter15(properties, outbound, inbound);
            Connector cmd = ExternalPooledConnectionFactoryService.createConnector15(ra);
            TransactionSupportEnum transactionSupport = ExternalPooledConnectionFactoryService.getTransactionSupport(this.txSupport);
            ConnectionDefinition common = ExternalPooledConnectionFactoryService.createConnDef(transactionSupport, this.bindInfo.getBindName(), this.minPoolSize, this.maxPoolSize, this.managedConnectionPoolClassName, this.enlistmentTrace);
            Activation activation = ExternalPooledConnectionFactoryService.createActivation(common, transactionSupport);
            ResourceAdapterActivatorService activator = new ResourceAdapterActivatorService(cmd, activation, ExternalPooledConnectionFactoryService.class.getClassLoader(), this.name);
            activator.setBindInfo(this.bindInfo);
            activator.setCreateBinderService(this.createBinderService);
            activator.addJndiAliases(this.jndiAliases);
            ServiceBuilder sb = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(ExternalPooledConnectionFactoryService.getResourceAdapterActivatorsServiceName(this.name), (Service)activator), (Injector)activator.getExecutorServiceInjector()).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, activator.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, activator.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, activator.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, activator.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, activator.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, activator.getConfigInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, activator.getCcmInjector());
            sb.requires(NamingService.SERVICE_NAME);
            sb.requires(this.capabilityServiceSupport.getCapabilityServiceName("org.wildfly.transactions.global-default-local-provider"));
            sb.requires(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{"default"}));
            sb.setInitialMode(ServiceController.Mode.PASSIVE).install();
            serviceTarget.addService(ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{this.name}), Service.NULL).install();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (isIj != null) {
                isIj.close();
            }
        }
    }

    private void configureCredential(List<ConfigProperty> properties) {
        if (this.credentialSourceSupplier != null) {
            try {
                char[] password;
                CredentialSource credentialSource = (CredentialSource)this.credentialSourceSupplier.get();
                if (credentialSource != null && (password = ((ClearPassword)((PasswordCredential)credentialSource.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword()) != null) {
                    properties.add(ExternalPooledConnectionFactoryService.simpleProperty15("password", String.class.getName(), new String(password)));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static TransactionSupportEnum getTransactionSupport(String txSupport) {
        try {
            return TransactionSupportEnum.valueOf((String)txSupport);
        }
        catch (RuntimeException e) {
            return TransactionSupportEnum.LocalTransaction;
        }
    }

    private static Activation createActivation(ConnectionDefinition common, TransactionSupportEnum transactionSupport) {
        List<ConnectionDefinition> definitions = Collections.singletonList(common);
        return new ActivationImpl(null, null, transactionSupport, definitions, Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), null, null);
    }

    private static ConnectionDefinition createConnDef(TransactionSupportEnum transactionSupport, String jndiName, int minPoolSize, int maxPoolSize, String managedConnectionPoolClassName, Boolean enlistmentTrace) throws ValidateException {
        PoolImpl pool;
        Integer minSize = minPoolSize == -1 ? null : Integer.valueOf(minPoolSize);
        Integer maxSize = maxPoolSize == -1 ? null : Integer.valueOf(maxPoolSize);
        boolean prefill = false;
        boolean useStrictMin = false;
        FlushStrategy flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
        Boolean isXA = Boolean.FALSE;
        if (transactionSupport == TransactionSupportEnum.XATransaction) {
            pool = new XaPoolImpl(minSize, Defaults.INITIAL_POOL_SIZE, maxSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, null, Defaults.FAIR, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL);
            isXA = Boolean.TRUE;
        } else {
            pool = new PoolImpl(minSize, Defaults.INITIAL_POOL_SIZE, maxSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, null, Defaults.FAIR);
        }
        TimeOutImpl timeOut = new TimeOutImpl(null, null, null, null, null){};
        SecurityImpl security = new SecurityImpl(null, null, true, false);
        Recovery recovery = new Recovery((Credential)new CredentialImpl(null, null, null, false, null), null, Boolean.TRUE);
        ValidationImpl validation = new ValidationImpl(Defaults.VALIDATE_ON_MATCH, null, null, Boolean.valueOf(false));
        return new org.jboss.jca.common.metadata.resourceadapter.ConnectionDefinitionImpl(Collections.emptyMap(), RAMANAGED_CONN_FACTORY, jndiName, ACTIVEMQ_CONN_DEF, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Defaults.SHARABLE, Defaults.ENLISTMENT, Defaults.CONNECTABLE, Boolean.valueOf(false), managedConnectionPoolClassName, enlistmentTrace, (Pool)pool, (TimeOut)timeOut, (Validation)validation, (Security)security, recovery, isXA);
    }

    private static Connector createConnector15(ResourceAdapter ra) {
        return new ConnectorImpl(Connector.Version.V_15, null, ExternalPooledConnectionFactoryService.str("Red Hat"), ExternalPooledConnectionFactoryService.str("JMS 1.1 Server"), ExternalPooledConnectionFactoryService.str("1.0"), null, ra, null, false, EMPTY_LOCL, EMPTY_LOCL, Collections.emptyList(), null);
    }

    private ResourceAdapter createResourceAdapter15(List<ConfigProperty> properties, OutboundResourceAdapter outbound, InboundResourceAdapter inbound) {
        return new ResourceAdapterImpl(ExternalPooledConnectionFactoryService.str(ACTIVEMQ_RESOURCE_ADAPTER), properties, outbound, inbound, Collections.emptyList(), Collections.emptyList(), null);
    }

    private InboundResourceAdapter createInbound(List<ConfigProperty> inboundProps) {
        List<RequiredConfigPropertyImpl> destination = Collections.singletonList(new RequiredConfigPropertyImpl(EMPTY_LOCL, ExternalPooledConnectionFactoryService.str("destination"), null));
        ActivationSpecImpl activation15 = new ActivationSpecImpl(ExternalPooledConnectionFactoryService.str(ACTIVEMQ_ACTIVATION), destination, inboundProps, null);
        List<MessageListenerImpl> messageListeners = Collections.singletonList(new MessageListenerImpl(ExternalPooledConnectionFactoryService.str(JMS_MESSAGE_LISTENER), (Activationspec)activation15, null));
        MessageAdapterImpl message = new MessageAdapterImpl(messageListeners, null);
        return new InboundResourceAdapterImpl((Messageadapter)message, null);
    }

    private static OutboundResourceAdapter createOutbound(List<ConfigProperty> outboundProperties) {
        ArrayList<ConnectionDefinitionImpl> definitions = new ArrayList<ConnectionDefinitionImpl>();
        ArrayList<ConfigProperty> props = new ArrayList<ConfigProperty>(outboundProperties);
        props.add(ExternalPooledConnectionFactoryService.simpleProperty15(SESSION_DEFAULT_TYPE, STRING_TYPE, JMS_QUEUE));
        props.add(ExternalPooledConnectionFactoryService.simpleProperty15(TRY_LOCK, INTEGER_TYPE, "0"));
        definitions.add(new ConnectionDefinitionImpl(ExternalPooledConnectionFactoryService.str(RAMANAGED_CONN_FACTORY), props, ExternalPooledConnectionFactoryService.str(RA_CONN_FACTORY), ExternalPooledConnectionFactoryService.str(RA_CONN_FACTORY_IMPL), ExternalPooledConnectionFactoryService.str(JMS_SESSION), ExternalPooledConnectionFactoryService.str(ACTIVEMQ_RA_SESSION), null));
        AuthenticationMechanismImpl basicPassword = new AuthenticationMechanismImpl(Collections.emptyList(), ExternalPooledConnectionFactoryService.str(BASIC_PASS), CredentialInterfaceEnum.PasswordCredential, null, null);
        return new OutboundResourceAdapterImpl(definitions, TransactionSupportEnum.XATransaction, Collections.singletonList(basicPassword), false, null, null, null);
    }

    private static XsdString str(String str) {
        return new XsdString(str, null);
    }

    private static ConfigProperty simpleProperty15(String name, String type, String value) {
        return new ConfigPropertyImpl(EMPTY_LOCL, ExternalPooledConnectionFactoryService.str(name), ExternalPooledConnectionFactoryService.str(type), ExternalPooledConnectionFactoryService.str(value), null, null, null, null, false, null, null, null, null);
    }

    public void stop(StopContext context) {
    }

    public CommandDispatcherFactory getCommandDispatcherFactory(String name) {
        return this.commandDispatcherFactories.get(name).get();
    }
}

