/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.EOFException;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.channel.IoWriteFutureImpl;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;

public class BufferedIoOutputStream
extends AbstractInnerCloseable
implements IoOutputStream {
    protected final IoOutputStream out;
    protected final Queue<IoWriteFutureImpl> writes = new ConcurrentLinkedQueue<IoWriteFutureImpl>();
    protected final AtomicReference<IoWriteFutureImpl> currentWrite = new AtomicReference();
    protected final Object id;

    public BufferedIoOutputStream(Object id, IoOutputStream out) {
        this.out = out;
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public IoWriteFuture writeBuffer(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            throw new EOFException("Closed - state=" + this.state);
        }
        IoWriteFutureImpl future = new IoWriteFutureImpl(this.getId(), buffer);
        this.writes.add(future);
        this.startWriting();
        return future;
    }

    protected void startWriting() throws IOException {
        final IoWriteFutureImpl future = this.writes.peek();
        if (future == null) {
            return;
        }
        if (!this.currentWrite.compareAndSet(null, future)) {
            return;
        }
        this.out.writeBuffer(future.getBuffer()).addListener((SshFutureListener)new SshFutureListener<IoWriteFuture>(){

            public void operationComplete(IoWriteFuture f) {
                if (f.isWritten()) {
                    future.setValue(Boolean.TRUE);
                } else {
                    future.setValue(f.getException());
                }
                BufferedIoOutputStream.this.finishWrite(future);
            }
        });
    }

    protected void finishWrite(IoWriteFutureImpl future) {
        this.writes.remove((Object)future);
        this.currentWrite.compareAndSet(future, null);
        try {
            this.startWriting();
        }
        catch (IOException e) {
            this.error("finishWrite({}) failed ({}) re-start writing: {}", this.out, e.getClass().getSimpleName(), e.getMessage(), e);
        }
    }

    protected Closeable getInnerCloseable() {
        return this.builder().when(this.getId(), this.writes).close((Closeable)this.out).build();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.out + "]";
    }
}

