/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.AbstractMapMarshaller;
import org.wildfly.clustering.marshalling.spi.util.LinkedHashMapExternalizer;

public class LinkedHashMapMarshaller
extends AbstractMapMarshaller<LinkedHashMap<Object, Object>> {
    private static final int ACCESS_ORDER_INDEX = 3;

    public LinkedHashMapMarshaller() {
        super(LinkedHashMap.class);
    }

    @Override
    public LinkedHashMap<Object, Object> readFrom(ProtoStreamReader reader) throws IOException {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(16, 0.75f, false);
        LinkedList<Object> keys = new LinkedList<Object>();
        LinkedList<Object> values = new LinkedList<Object>();
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    keys.add(reader.readObject(Any.class).get());
                    continue block5;
                }
                case 2: {
                    values.add(reader.readObject(Any.class).get());
                    continue block5;
                }
                case 3: {
                    map = new LinkedHashMap(16, 0.75f, reader.readBool());
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        Iterator keyIterator = keys.iterator();
        Iterator valueIterator = values.iterator();
        while (keyIterator.hasNext() || valueIterator.hasNext()) {
            map.put(keyIterator.next(), valueIterator.next());
        }
        return map;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, LinkedHashMap<Object, Object> map) throws IOException {
        super.writeTo(writer, map);
        boolean accessOrder = (Boolean)LinkedHashMapExternalizer.ACCESS_ORDER.apply(map);
        if (accessOrder) {
            writer.writeBool(3, accessOrder);
        }
    }

    @Override
    public Class<? extends LinkedHashMap<Object, Object>> getJavaClass() {
        return LinkedHashMap.class;
    }
}

