/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.persistence;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.wildfly.clustering.infinispan.spi.persistence.KeyFormat;
import org.wildfly.common.Assert;

public class IndexedKeyFormatMapper
implements TwoWayKey2StringMapper {
    private static final int HEX_RADIX = 16;
    private final Map<Class<?>, Integer> indexes = new IdentityHashMap();
    private final List<KeyFormat<Object>> keyFormats;
    private final int padding;

    public IndexedKeyFormatMapper(List<? extends KeyFormat<?>> keyFormats) {
        this.keyFormats = keyFormats;
        for (int i = 0; i < this.keyFormats.size(); ++i) {
            this.indexes.put(this.keyFormats.get(i).getTargetClass(), i);
        }
        this.padding = (int)(Math.log(this.keyFormats.size() - 1) / Math.log(16.0)) + 1;
    }

    public boolean isSupportedType(Class<?> keyType) {
        return this.indexes.containsKey(keyType);
    }

    public String getStringMapping(Object key) {
        Assert.checkNotNullParam((String)"key", (Object)key);
        Integer index = this.indexes.get(key.getClass());
        if (index == null) {
            throw new IllegalArgumentException(key.getClass().getName());
        }
        KeyFormat<Object> keyFormat = this.keyFormats.get(index);
        return String.format("%0" + this.padding + "X%s", index, keyFormat.format(key));
    }

    public Object getKeyMapping(String value) {
        int index = Integer.parseUnsignedInt(value.substring(0, this.padding), 16);
        KeyFormat<Object> keyFormat = this.keyFormats.get(index);
        return keyFormat.parse(value.substring(this.padding));
    }
}

