/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.jta.jca;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxWorkManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.WorkSynchronization;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple;
import com.arjuna.ats.jbossatx.logging.jbossatxLogger;
import com.arjuna.ats.jta.TransactionManager;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.JBossXATerminator;

public class XATerminator
extends XATerminatorImple
implements JBossXATerminator {
    private static final Xid[] NO_XIDS = new Xid[0];

    public void registerWork(Work work, Xid xid, long timeout) throws WorkCompletedException {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().importTransaction(xid, (int)timeout / 1000);
            switch (tx.getStatus()) {
                case 5: 
                case 6: {
                    throw new WorkCompletedException(jbossatxLogger.i18NLogger.get_jta_jca_inactive(), "3");
                }
                case 0: {
                    break;
                }
                default: {
                    throw new WorkCompletedException(jbossatxLogger.i18NLogger.get_jta_jca_completing(), "2");
                }
            }
            TxWorkManager.addWork((Work)work, (Transaction)tx);
            tx.registerSynchronization((Synchronization)new WorkSynchronization((Transaction)tx));
        }
        catch (WorkCompletedException ex) {
            throw ex;
        }
        catch (XAException ex) {
            throw new WorkCompletedException((Throwable)ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new WorkCompletedException(jbossatxLogger.i18NLogger.get_jta_jca_unknown(), "-1");
        }
    }

    public void startWork(Work work, Xid xid) throws WorkCompletedException {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().importTransaction(xid);
            if (!TxWorkManager.getWork((Transaction)tx).equals(work)) {
                throw new WorkCompletedException(jbossatxLogger.i18NLogger.get_jta_jca_unknownwork(), "-1");
            }
            TransactionManager.transactionManager().resume((Transaction)tx);
        }
        catch (XAException ex) {
            throw new WorkCompletedException((Throwable)ex);
        }
        catch (InvalidTransactionException ex) {
            throw new WorkCompletedException(jbossatxLogger.i18NLogger.get_jta_jca_inactive(), "3");
        }
        catch (SystemException ex) {
            throw new WorkCompletedException(jbossatxLogger.i18NLogger.get_jta_jca_unknown(), "-1");
        }
    }

    public void endWork(Work work, Xid xid) {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().importTransaction(xid);
            TransactionManager.transactionManager().suspend();
            TxWorkManager.removeWork((Work)work, (Transaction)tx);
        }
        catch (XAException xaException) {
            throw new RuntimeException(xaException);
        }
        catch (SystemException systemException) {
            throw new RuntimeException(systemException);
        }
    }

    public void cancelWork(Work work, Xid xid) {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().importTransaction(xid);
            TxWorkManager.removeWork((Work)work, (Transaction)tx);
        }
        catch (XAException xaException) {
            throw new RuntimeException(xaException);
        }
    }
}

