/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient.impl;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.httpclient.TLSSocketFactoryBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.opensaml.security.httpclient.impl.SecurityEnhancedTLSSocketFactory;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509CredentialKeyManager;

public final class SecurityEnhancedHttpClientSupport {
    private SecurityEnhancedHttpClientSupport() {
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildTLSSocketFactory() {
        return SecurityEnhancedHttpClientSupport.buildTLSSocketFactory(true, false);
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildTLSSocketFactoryWithClientTLS() {
        return SecurityEnhancedHttpClientSupport.buildTLSSocketFactory(true, true);
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildTLSSocketFactory(boolean supportTrustEngine, boolean supportClientTLS) {
        TLSSocketFactoryBuilder wrappedFactoryBuilder = new TLSSocketFactoryBuilder();
        if (supportTrustEngine || supportClientTLS) {
            wrappedFactoryBuilder.setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier());
            if (supportTrustEngine) {
                wrappedFactoryBuilder.setTrustManagers(Collections.singletonList(HttpClientSupport.buildNoTrustX509TrustManager()));
            }
            if (supportClientTLS) {
                wrappedFactoryBuilder.setKeyManagers(Collections.singletonList(new ThreadLocalX509CredentialKeyManager()));
            }
            return new SecurityEnhancedTLSSocketFactory((LayeredConnectionSocketFactory)wrappedFactoryBuilder.build(), (X509HostnameVerifier)new StrictHostnameVerifier());
        }
        return HttpClientSupport.buildStrictTLSSocketFactory();
    }
}

