/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import jakarta.resource.spi.ValidatingManagedConnectionFactory;
import jakarta.resource.spi.security.PasswordCredential;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.jboss.jca.adapters.AdaptersBundle;
import org.jboss.jca.adapters.AdaptersLogger;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnection;
import org.jboss.jca.adapters.jdbc.CheckValidConnectionSQL;
import org.jboss.jca.adapters.jdbc.JDBCResourceAdapter;
import org.jboss.jca.adapters.jdbc.SecurityActions;
import org.jboss.jca.adapters.jdbc.WrappedConnectionRequestInfo;
import org.jboss.jca.adapters.jdbc.WrapperDataSource;
import org.jboss.jca.adapters.jdbc.classloading.TCClassLoaderPlugin;
import org.jboss.jca.adapters.jdbc.extensions.novendor.NullExceptionSorter;
import org.jboss.jca.adapters.jdbc.extensions.novendor.NullStaleConnectionChecker;
import org.jboss.jca.adapters.jdbc.extensions.novendor.NullValidConnectionChecker;
import org.jboss.jca.adapters.jdbc.spi.ClassLoaderPlugin;
import org.jboss.jca.adapters.jdbc.spi.ExceptionSorter;
import org.jboss.jca.adapters.jdbc.spi.StaleConnectionChecker;
import org.jboss.jca.adapters.jdbc.spi.ValidConnectionChecker;
import org.jboss.jca.adapters.jdbc.spi.listener.ConnectionListener;
import org.jboss.jca.adapters.jdbc.spi.reauth.ReauthPlugin;
import org.jboss.jca.adapters.jdbc.statistics.JdbcStatisticsPlugin;
import org.jboss.jca.adapters.jdbc.util.Injection;
import org.jboss.jca.core.spi.statistics.Statistics;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public abstract class BaseWrapperManagedConnectionFactory
implements ManagedConnectionFactory,
ValidatingManagedConnectionFactory,
ResourceAdapterAssociation,
Statistics,
Serializable {
    static final long serialVersionUID = -84923705377702088L;
    public static final int TRACK_STATEMENTS_FALSE_INT = 0;
    public static final int TRACK_STATEMENTS_TRUE_INT = 1;
    public static final int TRACK_STATEMENTS_NOWARN_INT = 2;
    public static final String TRACK_STATEMENTS_FALSE = "false";
    public static final String TRACK_STATEMENTS_TRUE = "true";
    public static final String TRACK_STATEMENTS_NOWARN = "nowarn";
    protected final AdaptersLogger log = (AdaptersLogger)Logger.getMessageLogger(AdaptersLogger.class, (String)this.getClass().getName());
    protected static AdaptersBundle bundle = (AdaptersBundle)Messages.getBundle(AdaptersBundle.class);
    private static boolean copyGssCredentials;
    private JDBCResourceAdapter jdbcRA;
    private PrintWriter printWriter;
    protected String userName;
    protected String password;
    protected int transactionIsolation = -1;
    protected Integer preparedStatementCacheSize = 0;
    protected boolean doQueryTimeout = false;
    protected String newConnectionSQL;
    protected String checkValidConnectionSQL;
    protected String validConnectionCheckerClassName;
    private ClassLoader validConnectionCheckerClassLoader;
    private String validConnectionCheckerProperties;
    protected final Properties validConnectionCheckerProps = new Properties();
    protected ValidConnectionChecker connectionChecker;
    protected StaleConnectionChecker staleConnectionChecker;
    private String staleConnectionCheckerClassName;
    private ClassLoader staleConnectionCheckerClassLoader;
    private String staleConnectionCheckerProperties;
    protected final Properties staleConnectionCheckerProps = new Properties();
    private String exceptionSorterClassName;
    private ClassLoader exceptionSorterClassLoader;
    private String exceptionSorterProperties;
    private final Properties exceptionSorterProps = new Properties();
    private ExceptionSorter exceptionSorter;
    protected int trackStatements = 2;
    protected Boolean sharePS = Boolean.FALSE;
    protected Boolean isTransactionQueryTimeout = Boolean.FALSE;
    protected Integer queryTimeout = 0;
    protected String urlDelimiter;
    protected String urlSelectorStrategyClassName;
    private Integer useTryLock = 60;
    private Boolean spy = Boolean.FALSE;
    private String jndiName;
    private Boolean reauthEnabled = Boolean.FALSE;
    private String reauthPluginClassName;
    private String reauthPluginProperties;
    private ReauthPlugin reauthPlugin;
    private ClassLoaderPlugin classLoaderPlugin;
    private String userTransactionJndiName;
    private JdbcStatisticsPlugin statisticsPlugin = new JdbcStatisticsPlugin();
    private Boolean jta = Boolean.TRUE;
    private String connectionListenerClassName;
    private String connectionListenerProperties;
    private ConnectionListener connectionListenerPlugin;
    private ClassLoader originalTCCL;

    public ResourceAdapter getResourceAdapter() {
        return this.jdbcRA;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        this.jdbcRA = (JDBCResourceAdapter)ra;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public void setLogWriter(PrintWriter v) throws ResourceException {
        this.printWriter = v;
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        if (this.getURLDelimiter() != null && !this.getURLDelimiter().trim().equals("")) {
            this.log.haDetected(this.getJndiName());
        }
        return new WrapperDataSource(this, cm, this.getClassLoaderPlugin());
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new ResourceException(bundle.nonManagedEnvironment());
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(Integer size) {
        if (size != null) {
            this.preparedStatementCacheSize = size;
        }
    }

    public Boolean getSharePreparedStatements() {
        return this.sharePS;
    }

    public void setSharePreparedStatements(Boolean sharePS) {
        if (sharePS != null) {
            this.sharePS = sharePS;
        }
    }

    public String getTransactionIsolation() {
        switch (this.transactionIsolation) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
            case -1: {
                return "DEFAULT";
            }
        }
        return Integer.toString(this.transactionIsolation);
    }

    public void setTransactionIsolation(String transactionIsolation) {
        if (transactionIsolation.equals("TRANSACTION_NONE")) {
            this.transactionIsolation = 0;
        } else if (transactionIsolation.equals("TRANSACTION_READ_COMMITTED")) {
            this.transactionIsolation = 2;
        } else if (transactionIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
            this.transactionIsolation = 1;
        } else if (transactionIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
            this.transactionIsolation = 4;
        } else if (transactionIsolation.equals("TRANSACTION_SERIALIZABLE")) {
            this.transactionIsolation = 8;
        } else {
            try {
                this.transactionIsolation = Integer.parseInt(transactionIsolation);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Setting Isolation level to unknown state: " + transactionIsolation);
            }
        }
    }

    public String getNewConnectionSQL() {
        return this.newConnectionSQL;
    }

    public void setNewConnectionSQL(String newConnectionSQL) {
        this.newConnectionSQL = newConnectionSQL;
    }

    public String getCheckValidConnectionSQL() {
        return this.checkValidConnectionSQL;
    }

    public void setCheckValidConnectionSQL(String checkValidConnectionSQL) {
        this.checkValidConnectionSQL = checkValidConnectionSQL;
    }

    public String getStaleConnectionCheckerClassName() {
        return this.staleConnectionCheckerClassName;
    }

    public void setStaleConnectionCheckerClassName(String staleConnectionCheckerClassName) {
        this.staleConnectionCheckerClassName = staleConnectionCheckerClassName;
    }

    public ClassLoader getStaleConnectionClassLoader() {
        return this.staleConnectionCheckerClassLoader;
    }

    public void setStaleConnectionCheckerClassLoader(ClassLoader staleConnectionCheckerClassLoader) {
        this.staleConnectionCheckerClassLoader = staleConnectionCheckerClassLoader;
    }

    public String getTrackStatements() {
        if (this.trackStatements == 0) {
            return TRACK_STATEMENTS_FALSE;
        }
        if (this.trackStatements == 1) {
            return TRACK_STATEMENTS_TRUE;
        }
        return TRACK_STATEMENTS_NOWARN;
    }

    public void setTrackStatements(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value for trackStatements");
        }
        String trimmed = value.trim();
        this.trackStatements = trimmed.equalsIgnoreCase(TRACK_STATEMENTS_FALSE) ? 0 : (trimmed.equalsIgnoreCase(TRACK_STATEMENTS_TRUE) ? 1 : 2);
    }

    public String getExceptionSorterClassName() {
        return this.exceptionSorterClassName;
    }

    public void setExceptionSorterClassName(String exceptionSorterClassName) {
        this.exceptionSorterClassName = exceptionSorterClassName;
    }

    public ClassLoader getExceptionSorterClassLoader() {
        return this.exceptionSorterClassLoader;
    }

    public void setExceptionSorterClassLoader(ClassLoader exceptionSorterClassLoader) {
        this.exceptionSorterClassLoader = exceptionSorterClassLoader;
    }

    public String getValidConnectionCheckerClassName() {
        return this.validConnectionCheckerClassName;
    }

    public void setValidConnectionCheckerClassName(String validConnectionCheckerClassName) {
        this.validConnectionCheckerClassName = validConnectionCheckerClassName;
    }

    public ClassLoader getValidConnectionCheckerClassLoader() {
        return this.validConnectionCheckerClassLoader;
    }

    public void setValidConnectionCheckerClassLoader(ClassLoader validConnectionCheckerClassLoader) {
        this.validConnectionCheckerClassLoader = validConnectionCheckerClassLoader;
    }

    public Boolean isTransactionQueryTimeout() {
        return this.isTransactionQueryTimeout;
    }

    public void setTransactionQueryTimeout(Boolean value) {
        if (value != null) {
            this.isTransactionQueryTimeout = value;
        }
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(Integer timeout) {
        if (timeout != null) {
            this.queryTimeout = timeout;
        }
    }

    public Integer getUseTryLock() {
        return this.useTryLock;
    }

    public void setUseTryLock(Integer useTryLock) {
        if (useTryLock != null) {
            this.useTryLock = useTryLock;
        }
    }

    public boolean isDoLocking() {
        return this.useTryLock >= 0;
    }

    public void setSpy(Boolean v) {
        if (v != null) {
            this.spy = v;
        }
    }

    public Boolean getSpy() {
        return this.spy;
    }

    public void setJndiName(String v) {
        if (v != null) {
            this.jndiName = v;
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Boolean getReauthEnabled() {
        return this.reauthEnabled;
    }

    public void setReauthEnabled(Boolean v) {
        if (v != null) {
            this.reauthEnabled = v;
        }
    }

    public String getReauthPluginClassName() {
        return this.reauthPluginClassName;
    }

    public void setReauthPluginClassName(String v) {
        if (v != null) {
            this.reauthPluginClassName = v;
        }
    }

    public String getReauthPluginProperties() {
        return this.reauthPluginProperties;
    }

    public void setReauthPluginProperties(String v) {
        if (v != null) {
            this.reauthPluginProperties = v;
        }
    }

    synchronized void loadReauthPlugin() throws ResourceException {
        if (this.reauthPlugin != null) {
            return;
        }
        if (Boolean.FALSE.equals(this.reauthEnabled)) {
            throw new IllegalStateException("Reauthentication not enabled");
        }
        if (this.reauthPluginClassName == null || this.reauthPluginClassName.trim().equals("")) {
            throw new IllegalStateException("ReauthPlugin class name not defined");
        }
        Class<?> clz = null;
        ClassLoader usedCl = null;
        try {
            clz = Class.forName(this.reauthPluginClassName, true, this.getClassLoaderPlugin().getClassLoader());
            usedCl = this.getClassLoaderPlugin().getClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clz == null) {
            try {
                clz = Class.forName(this.reauthPluginClassName, true, new TCClassLoaderPlugin().getClassLoader());
                usedCl = new TCClassLoaderPlugin().getClassLoader();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clz == null) {
            try {
                clz = Class.forName(this.reauthPluginClassName, true, SecurityActions.getClassLoader(BaseWrapperManagedConnectionFactory.class));
                usedCl = SecurityActions.getClassLoader(BaseWrapperManagedConnectionFactory.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ResourceException(bundle.errorDuringLoadingReauthPlugin(), (Throwable)cnfe);
            }
        }
        try {
            this.reauthPlugin = (ReauthPlugin)clz.newInstance();
            if (this.reauthPluginProperties != null) {
                Injection injector = new Injection();
                StringTokenizer st = new StringTokenizer(this.reauthPluginProperties, ",");
                while (st.hasMoreTokens()) {
                    String keyValue = st.nextToken();
                    int split = keyValue.indexOf("|");
                    if (split == -1) {
                        throw new IllegalStateException("Reauth plugin property incorrect: " + keyValue);
                    }
                    String key = keyValue.substring(0, split);
                    String value = "";
                    if (keyValue.length() > split + 1) {
                        value = keyValue.substring(split + 1);
                    }
                    injector.inject(this.reauthPlugin, key, value);
                }
            }
            this.reauthPlugin.initialize(usedCl);
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.errorDuringLoadingReauthPlugin(), t);
        }
    }

    ReauthPlugin getReauthPlugin() {
        return this.reauthPlugin;
    }

    public String getConnectionListenerClassName() {
        return this.connectionListenerClassName;
    }

    public void setConnectionListenerClassName(String v) {
        if (v != null) {
            this.connectionListenerClassName = v;
        }
    }

    public String getConnectionListenerProperties() {
        return this.connectionListenerProperties;
    }

    public void setConnectionListenerProperties(String v) {
        if (v != null) {
            this.connectionListenerProperties = v;
        }
    }

    synchronized void loadConnectionListenerPlugin() throws ResourceException {
        if (this.connectionListenerPlugin != null) {
            return;
        }
        if (this.connectionListenerClassName == null || this.connectionListenerClassName.trim().equals("")) {
            throw new IllegalStateException("ConnectionListener class name not defined");
        }
        Class<?> clz = null;
        ClassLoader usedCl = null;
        try {
            clz = Class.forName(this.connectionListenerClassName, true, this.getClassLoaderPlugin().getClassLoader());
            usedCl = this.getClassLoaderPlugin().getClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clz == null) {
            try {
                clz = Class.forName(this.connectionListenerClassName, true, new TCClassLoaderPlugin().getClassLoader());
                usedCl = new TCClassLoaderPlugin().getClassLoader();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clz == null) {
            try {
                clz = Class.forName(this.connectionListenerClassName, true, SecurityActions.getClassLoader(BaseWrapperManagedConnectionFactory.class));
                usedCl = SecurityActions.getClassLoader(BaseWrapperManagedConnectionFactory.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ResourceException(bundle.errorDuringLoadingConnectionListenerPlugin(), (Throwable)cnfe);
            }
        }
        try {
            this.connectionListenerPlugin = (ConnectionListener)clz.newInstance();
            if (this.connectionListenerProperties != null) {
                Injection injector = new Injection();
                StringTokenizer st = new StringTokenizer(this.connectionListenerProperties, ",");
                while (st.hasMoreTokens()) {
                    String keyValue = st.nextToken();
                    int split = keyValue.indexOf("|");
                    if (split == -1) {
                        throw new IllegalStateException("ConnectionListener property incorrect: " + keyValue);
                    }
                    String key = keyValue.substring(0, split);
                    String value = "";
                    if (keyValue.length() > split + 1) {
                        value = keyValue.substring(split + 1);
                    }
                    injector.inject(this.connectionListenerPlugin, key, value);
                }
            }
            this.connectionListenerPlugin.initialize(usedCl);
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.errorDuringLoadingConnectionListenerPlugin(), t);
        }
    }

    ConnectionListener getConnectionListenerPlugin() {
        try {
            if (this.connectionListenerClassName != null && this.connectionListenerPlugin == null) {
                ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
                try {
                    SecurityActions.setThreadContextClassLoader(this.originalTCCL);
                    this.loadConnectionListenerPlugin();
                }
                finally {
                    SecurityActions.setThreadContextClassLoader(tccl);
                }
            }
            return this.connectionListenerPlugin;
        }
        catch (ResourceException re) {
            this.log.unableToLoadConnectionListener(re.getMessage(), re);
            return null;
        }
    }

    public String getURLDelimiter() {
        return this.urlDelimiter;
    }

    public void setURLDelimiter(String urlDelimiter) {
        this.urlDelimiter = urlDelimiter;
    }

    public String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public void setUrlSelectorStrategyClassName(String urlSelectorStrategyClassName) {
        this.urlSelectorStrategyClassName = urlSelectorStrategyClassName;
    }

    public JdbcStatisticsPlugin getStatistics() {
        return this.statisticsPlugin;
    }

    public Boolean isJTA() {
        return this.jta;
    }

    public void setJTA(Boolean v) {
        if (v != null) {
            this.jta = v;
        }
    }

    TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.jdbcRA.getTransactionSynchronizationRegistry();
    }

    public Set<BaseWrapperManagedConnection> getInvalidConnections(Set connectionSet) throws ResourceException {
        HashSet<BaseWrapperManagedConnection> invalid = new HashSet<BaseWrapperManagedConnection>();
        for (Object anonymous : connectionSet) {
            if (!(anonymous instanceof BaseWrapperManagedConnection)) continue;
            BaseWrapperManagedConnection mc = (BaseWrapperManagedConnection)anonymous;
            Connection c = null;
            try {
                mc.checkTransaction();
                c = mc.getRealConnection();
                SQLException e = this.isValidConnection(c);
                if (e == null) continue;
                this.log.invalidConnection(c.toString(), e);
                invalid.add(mc);
            }
            catch (SQLException se) {
                invalid.add(mc);
            }
        }
        return invalid;
    }

    protected Properties getConnectionProperties(Properties connectionProps, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri != null && cri.getClass() != WrappedConnectionRequestInfo.class) {
            throw new ResourceException(bundle.wrongConnectionRequestInfo(cri.getClass().getName()));
        }
        Properties props = new Properties();
        if (connectionProps != null) {
            props.putAll((Map<?, ?>)connectionProps);
        }
        WrappedConnectionRequestInfo lcri = (WrappedConnectionRequestInfo)cri;
        if (subject != null) {
            if (SubjectActions.addMatchingProperties(subject, lcri, props, this.userName, this.password, this)) {
                return props;
            }
            throw new ResourceException(bundle.noMatchingCredentials());
        }
        if (lcri != null) {
            props.setProperty("user", lcri.getUserName() == null ? "" : lcri.getUserName());
            props.setProperty("password", lcri.getPassword() == null ? "" : lcri.getPassword());
            return props;
        }
        if (this.userName != null) {
            props.setProperty("user", this.userName);
            props.setProperty("password", this.password == null ? "" : this.password);
        }
        return props;
    }

    Object loadPlugin(String plugin, ClassLoader classLoader, Properties props) throws Exception {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin is null");
        }
        if (plugin.trim().equals("")) {
            throw new IllegalArgumentException("Plugin isn't defined");
        }
        Class<?> clz = null;
        if (classLoader != null) {
            clz = Class.forName(plugin, true, classLoader);
        }
        if (clz == null) {
            try {
                clz = Class.forName(plugin, true, this.getClassLoaderPlugin().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clz == null) {
            try {
                clz = Class.forName(plugin, true, new TCClassLoaderPlugin().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clz == null) {
            try {
                clz = Class.forName(plugin, true, SecurityActions.getClassLoader(BaseWrapperManagedConnectionFactory.class));
            }
            catch (ClassNotFoundException cnfe) {
                throw new Exception("Unable to load: " + plugin);
            }
        }
        Object result = clz.newInstance();
        if (props != null) {
            Injection injection = new Injection();
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                injection.inject(result, (String)prop.getKey(), (String)prop.getValue());
            }
        }
        return result;
    }

    public boolean isExceptionFatal(SQLException e) {
        try {
            if (this.exceptionSorter != null) {
                return this.exceptionSorter.isExceptionFatal(e);
            }
            if (this.exceptionSorterClassName != null && !this.exceptionSorterClassName.trim().equals("")) {
                try {
                    Object o = this.loadPlugin(this.exceptionSorterClassName, this.exceptionSorterClassLoader, this.exceptionSorterProps);
                    if (o != null && o instanceof ExceptionSorter) {
                        this.exceptionSorter = (ExceptionSorter)o;
                        return this.exceptionSorter.isExceptionFatal(e);
                    }
                    this.log.disableExceptionSorter(this.jndiName);
                    this.exceptionSorter = new NullExceptionSorter();
                }
                catch (Exception e2) {
                    this.log.disableExceptionSorterExt(this.jndiName, e2);
                    this.exceptionSorter = new NullExceptionSorter();
                }
            }
        }
        catch (Throwable t) {
            this.log.errorDuringExceptionSorter(this.jndiName, t);
        }
        return false;
    }

    SQLException isValidConnection(Connection c) {
        if (this.connectionChecker != null) {
            return this.connectionChecker.isValidConnection(c);
        }
        if (this.validConnectionCheckerClassName != null && !this.validConnectionCheckerClassName.trim().equals("")) {
            try {
                Object o = this.loadPlugin(this.validConnectionCheckerClassName, this.validConnectionCheckerClassLoader, this.validConnectionCheckerProps);
                if (o != null && o instanceof ValidConnectionChecker) {
                    this.connectionChecker = (ValidConnectionChecker)o;
                    return this.connectionChecker.isValidConnection(c);
                }
                this.log.disableValidationChecker(this.jndiName);
                this.connectionChecker = new NullValidConnectionChecker();
            }
            catch (Exception e) {
                this.log.disableValidationCheckerExt(this.jndiName, e);
                this.connectionChecker = new NullValidConnectionChecker();
            }
        }
        if (this.checkValidConnectionSQL != null) {
            this.connectionChecker = new CheckValidConnectionSQL(this.checkValidConnectionSQL);
            return this.connectionChecker.isValidConnection(c);
        }
        return null;
    }

    boolean isStaleConnection(SQLException e) {
        if (this.staleConnectionChecker != null) {
            return this.staleConnectionChecker.isStaleConnection(e);
        }
        if (this.staleConnectionCheckerClassName != null && !this.staleConnectionCheckerClassName.trim().equals("")) {
            try {
                Object o = this.loadPlugin(this.staleConnectionCheckerClassName, this.staleConnectionCheckerClassLoader, this.staleConnectionCheckerProps);
                if (o != null && o instanceof StaleConnectionChecker) {
                    this.staleConnectionChecker = (StaleConnectionChecker)o;
                    return this.staleConnectionChecker.isStaleConnection(e);
                }
                this.log.disableStaleChecker(this.jndiName);
                this.staleConnectionChecker = new NullStaleConnectionChecker();
            }
            catch (Exception ex2) {
                this.log.disableStaleCheckerExt(this.jndiName, ex2);
                this.staleConnectionChecker = new NullStaleConnectionChecker();
            }
        }
        return false;
    }

    public final Properties getValidConnectionCheckerProps() {
        return this.validConnectionCheckerProps;
    }

    public final Properties getStaleConnectionCheckerProps() {
        return this.staleConnectionCheckerProps;
    }

    public final Properties getExceptionSorterProps() {
        return this.exceptionSorterProps;
    }

    public final String getValidConnectionCheckerProperties() {
        return this.validConnectionCheckerProperties;
    }

    public final void setValidConnectionCheckerProperties(String validConnectionCheckerProperties) {
        this.validConnectionCheckerProperties = validConnectionCheckerProperties;
        this.validConnectionCheckerProps.clear();
        if (validConnectionCheckerProperties != null) {
            validConnectionCheckerProperties = validConnectionCheckerProperties.replaceAll("\\\\", "\\\\\\\\");
            validConnectionCheckerProperties = validConnectionCheckerProperties.replaceAll(";", "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(validConnectionCheckerProperties.getBytes());
            try {
                this.validConnectionCheckerProps.load(is);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load connection properties", ioe);
            }
        }
    }

    public final String getStaleConnectionCheckerProperties() {
        return this.staleConnectionCheckerProperties;
    }

    public final void setStaleConnectionCheckerProperties(String staleConnectionCheckerProperties) {
        this.staleConnectionCheckerProperties = staleConnectionCheckerProperties;
        this.staleConnectionCheckerProps.clear();
        if (staleConnectionCheckerProperties != null) {
            staleConnectionCheckerProperties = staleConnectionCheckerProperties.replaceAll("\\\\", "\\\\\\\\");
            staleConnectionCheckerProperties = staleConnectionCheckerProperties.replaceAll(";", "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(staleConnectionCheckerProperties.getBytes());
            try {
                this.staleConnectionCheckerProps.load(is);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load connection properties", ioe);
            }
        }
    }

    public final String getExceptionSorterProperties() {
        return this.exceptionSorterProperties;
    }

    public final void setExceptionSorterProperties(String exceptionSorterProperties) {
        this.exceptionSorterProperties = exceptionSorterProperties;
        this.exceptionSorterProps.clear();
        if (exceptionSorterProperties != null) {
            exceptionSorterProperties = exceptionSorterProperties.replaceAll("\\\\", "\\\\\\\\");
            exceptionSorterProperties = exceptionSorterProperties.replaceAll(";", "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(exceptionSorterProperties.getBytes());
            try {
                this.exceptionSorterProps.load(is);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load connection properties", ioe);
            }
        }
    }

    public final ClassLoaderPlugin getClassLoaderPlugin() {
        if (this.classLoaderPlugin == null) {
            this.classLoaderPlugin = new TCClassLoaderPlugin();
        }
        return this.classLoaderPlugin;
    }

    public final void setClassLoaderPlugin(ClassLoaderPlugin clPlugin) {
        this.classLoaderPlugin = clPlugin;
    }

    public final void setOriginalTCCLn(ClassLoader cl) {
        this.originalTCCL = cl;
    }

    static {
        String c = SecurityActions.getSystemProperty("ironjacamar.jdbc.kerberos.copygsscredentials");
        copyGssCredentials = c != null ? Boolean.valueOf(c) : false;
    }

    static class SubjectActions
    implements PrivilegedAction<Boolean> {
        private final Subject subject;
        private final WrappedConnectionRequestInfo cri;
        private final Properties props;
        private final String userName;
        private final String password;
        private final ManagedConnectionFactory mcf;

        SubjectActions(Subject subject, WrappedConnectionRequestInfo cri, Properties props, String userName, String password, ManagedConnectionFactory mcf) {
            this.subject = subject;
            this.cri = cri;
            this.props = props;
            this.userName = userName;
            this.password = password;
            this.mcf = mcf;
        }

        private Boolean doCheck() {
            Set<GSSCredential> gssCreds;
            Set<PasswordCredential> pcCreds = this.subject.getPrivateCredentials(PasswordCredential.class);
            if (pcCreds != null && pcCreds.size() > 0) {
                for (PasswordCredential cred : pcCreds) {
                    if (!cred.getManagedConnectionFactory().equals((Object)this.mcf)) continue;
                    String user = null;
                    String pass = null;
                    if (this.cri != null) {
                        user = this.cri.getUserName();
                        pass = this.cri.getPassword();
                    } else {
                        user = cred.getUserName();
                        if (cred.getPassword() != null) {
                            pass = new String(cred.getPassword());
                        }
                    }
                    if (this.userName != null) {
                        user = this.userName;
                        if (this.password != null) {
                            pass = this.password;
                        }
                    }
                    this.props.setProperty("user", user == null ? "" : user);
                    this.props.setProperty("password", pass == null ? "" : pass);
                    return Boolean.TRUE;
                }
            }
            if ((gssCreds = this.subject.getPrivateCredentials(GSSCredential.class)) != null && gssCreds.size() > 0) {
                boolean done = false;
                for (GSSCredential cred : gssCreds) {
                    String user = null;
                    String pass = null;
                    if (this.cri != null) {
                        user = this.cri.getUserName();
                        pass = this.cri.getPassword();
                        done = true;
                    } else {
                        try {
                            Oid krb5 = new Oid("1.2.840.113554.1.2.2");
                            GSSName gssName = cred.getName(krb5);
                            user = gssName.toString();
                            done = true;
                        }
                        catch (GSSException gSSException) {
                            // empty catch block
                        }
                    }
                    if (!done) continue;
                    if (this.userName != null) {
                        user = this.userName;
                        if (this.password != null) {
                            pass = this.password;
                        }
                    }
                    if (copyGssCredentials) {
                        this.props.setProperty("user", user == null ? "" : user);
                        this.props.setProperty("password", pass == null ? "" : pass);
                    }
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean run() {
            return this.doCheck();
        }

        static boolean addMatchingProperties(Subject subject, WrappedConnectionRequestInfo cri, Properties props, String userName, String password, ManagedConnectionFactory mcf) {
            SubjectActions action = new SubjectActions(subject, cri, props, userName, password, mcf);
            Boolean matched = Boolean.FALSE;
            matched = System.getSecurityManager() == null ? action.doCheck() : AccessController.doPrivileged(action);
            return matched;
        }
    }
}

