/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.servlet;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.servlet.RequestData;

public final class RequestCopier {
    private RequestCopier() {
    }

    public static RequestData copy(HttpServletRequest request) {
        RequestData requestData = new RequestData();
        requestData.setCookies(RequestCopier.copyCookies(request.getCookies()));
        requestData.setHeaders(RequestCopier.copyHeaders(request));
        requestData.setParameters(RequestCopier.copyParameters(request.getParameterMap()));
        requestData.setLocales(Collections.list(request.getLocales()));
        requestData.setMethod(request.getMethod());
        requestData.setRequestURL(request.getRequestURL().toString());
        requestData.setQueryString(request.getQueryString());
        return requestData;
    }

    private static Cookie[] copyCookies(Cookie[] cookies) {
        if (Utils.isEmpty(cookies)) {
            return cookies;
        }
        ArrayList<Cookie> copiedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            copiedCookies.add((Cookie)cookie.clone());
        }
        return copiedCookies.toArray(new Cookie[copiedCookies.size()]);
    }

    private static Map<String, List<String>> copyHeaders(HttpServletRequest request) {
        HashMap<String, List<String>> copiedHeaders = new HashMap<String, List<String>>();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            copiedHeaders.put(headerName, Collections.list(request.getHeaders(headerName)));
        }
        return copiedHeaders;
    }

    private static Map<String, String[]> copyParameters(Map<String, String[]> parameters) {
        if (RequestCopier.isEmptyMap(parameters)) {
            return Collections.emptyMap();
        }
        HashMap<String, String[]> copiedParameters = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> parameter : parameters.entrySet()) {
            copiedParameters.put(parameter.getKey(), (String[])Arrays.copyOf((Object[])parameter.getValue(), parameter.getValue().length));
        }
        return copiedParameters;
    }

    private static boolean isEmptyMap(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }
}

