/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.cdi;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.security.auth.message.AuthException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.cdi.CdiUtils;
import org.glassfish.soteria.mechanisms.LoginToContinueHolder;
import org.glassfish.soteria.servlet.AuthenticationData;
import org.glassfish.soteria.servlet.HttpServletRequestDelegator;
import org.glassfish.soteria.servlet.RequestCopier;
import org.glassfish.soteria.servlet.RequestData;

@Interceptor
@LoginToContinue
@Priority(value=220)
public class LoginToContinueInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private BeanManager beanManager;
    @Inject
    @Intercepted
    private Bean<?> interceptedBean;
    private static final String ORIGINAL_REQUEST_DATA_SESSION_NAME = "org.glassfish.soteria.original.request";
    private static final String AUTHENTICATION_DATA_SESSION_NAME = "org.glassfish.soteria.authentication";
    private static final String CALLER_INITIATED_AUTHENTICATION_SESSION_NAME = "org.glassfish.soteria.caller_initiated_authentication";

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        if (Utils.isImplementationOf(invocationContext.getMethod(), Utils.validateRequestMethod)) {
            return this.validateRequest(invocationContext, (HttpServletRequest)Utils.getParam(invocationContext, 0), (HttpServletResponse)Utils.getParam(invocationContext, 1), (HttpMessageContext)Utils.getParam(invocationContext, 2));
        }
        return invocationContext.proceed();
    }

    private AuthenticationStatus validateRequest(InvocationContext invocationContext, HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws Exception {
        this.tryClean(httpMessageContext);
        if (this.isCallerInitiatedAuthentication(request)) {
            return this.processCallerInitiatedAuthentication(invocationContext, request, response, httpMessageContext);
        }
        return this.processContainerInitiatedAuthentication(invocationContext, request, response, httpMessageContext);
    }

    private void tryClean(HttpMessageContext httpMessageContext) {
        if (this.isOnProtectedURLWithStaleData(httpMessageContext)) {
            this.removeSavedRequest(httpMessageContext.getRequest());
            this.removeCallerInitiatedAuthentication(httpMessageContext.getRequest());
        }
        if (httpMessageContext.getAuthParameters().isNewAuthentication()) {
            this.saveCallerInitiatedAuthentication(httpMessageContext.getRequest());
            this.removeSavedRequest(httpMessageContext.getRequest());
            this.removeSavedAuthentication(httpMessageContext.getRequest());
        }
    }

    private AuthenticationStatus processCallerInitiatedAuthentication(InvocationContext invocationContext, HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws Exception {
        AuthenticationStatus authstatus;
        try {
            authstatus = (AuthenticationStatus)invocationContext.proceed();
        }
        catch (AuthException e) {
            authstatus = AuthenticationStatus.SEND_FAILURE;
        }
        if (authstatus == AuthenticationStatus.SUCCESS) {
            if (httpMessageContext.getCallerPrincipal() == null) {
                return AuthenticationStatus.SUCCESS;
            }
            this.removeCallerInitiatedAuthentication(httpMessageContext.getRequest());
        }
        return authstatus;
    }

    private AuthenticationStatus processContainerInitiatedAuthentication(InvocationContext invocationContext, HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws Exception {
        if (this.isOnInitialProtectedURL(httpMessageContext)) {
            this.saveRequest(request);
            LoginToContinue loginToContinueAnnotation = this.getLoginToContinueAnnotation(invocationContext);
            if (loginToContinueAnnotation.useForwardToLogin()) {
                return httpMessageContext.forward(loginToContinueAnnotation.loginPage());
            }
            return httpMessageContext.redirect(Utils.getBaseURL(request) + loginToContinueAnnotation.loginPage());
        }
        if (this.isOnLoginPostback(request)) {
            AuthenticationStatus authstatus;
            try {
                authstatus = (AuthenticationStatus)invocationContext.proceed();
            }
            catch (AuthException e) {
                authstatus = AuthenticationStatus.SEND_FAILURE;
            }
            if (authstatus == AuthenticationStatus.SUCCESS) {
                if (httpMessageContext.getCallerPrincipal() == null) {
                    return AuthenticationStatus.SUCCESS;
                }
                RequestData savedRequest = this.getSavedRequest(request);
                if (!savedRequest.matchesRequest(request)) {
                    this.saveAuthentication(request, new AuthenticationData(httpMessageContext.getCallerPrincipal(), httpMessageContext.getGroups()));
                    return httpMessageContext.redirect(savedRequest.getFullRequestURL());
                }
            } else {
                if (authstatus == AuthenticationStatus.SEND_FAILURE) {
                    String errorPage = this.getLoginToContinueAnnotation(invocationContext).errorPage();
                    if (Utils.isEmpty(errorPage)) {
                        return authstatus;
                    }
                    return httpMessageContext.redirect(Utils.getBaseURL(request) + errorPage);
                }
                return authstatus;
            }
        }
        if (this.isOnOriginalURLAfterAuthenticate(request)) {
            RequestData requestData = this.removeSavedRequest(request);
            AuthenticationData authenticationData = this.removeSavedAuthentication(request);
            return httpMessageContext.withRequest((HttpServletRequest)new HttpServletRequestDelegator(request, requestData)).notifyContainerAboutLogin(authenticationData.getPrincipal(), authenticationData.getGroups());
        }
        return (AuthenticationStatus)invocationContext.proceed();
    }

    private boolean isCallerInitiatedAuthentication(HttpServletRequest request) {
        return Boolean.TRUE.equals(this.getCallerInitiatedAuthentication(request));
    }

    private boolean isOnProtectedURLWithStaleData(HttpMessageContext httpMessageContext) {
        return httpMessageContext.isProtected() && !httpMessageContext.isAuthenticationRequest() && this.getSavedRequest(httpMessageContext.getRequest()) != null && this.getSavedAuthentication(httpMessageContext.getRequest()) == null && !httpMessageContext.getRequest().getRequestURI().endsWith("j_security_check");
    }

    private boolean isOnInitialProtectedURL(HttpMessageContext httpMessageContext) {
        return httpMessageContext.isProtected() && !httpMessageContext.isAuthenticationRequest() && this.getSavedRequest(httpMessageContext.getRequest()) == null && this.getSavedAuthentication(httpMessageContext.getRequest()) == null && !httpMessageContext.getRequest().getRequestURI().endsWith("j_security_check");
    }

    private boolean isOnLoginPostback(HttpServletRequest request) {
        return this.getSavedRequest(request) != null && this.getSavedAuthentication(request) == null;
    }

    private boolean isOnOriginalURLAfterAuthenticate(HttpServletRequest request) {
        RequestData savedRequest = this.getSavedRequest(request);
        AuthenticationData authenticationData = this.getSavedAuthentication(request);
        return Utils.notNull(savedRequest, authenticationData) && savedRequest.matchesRequest(request);
    }

    private LoginToContinue getLoginToContinueAnnotation(InvocationContext invocationContext) {
        if (invocationContext.getTarget() instanceof LoginToContinueHolder) {
            return ((LoginToContinueHolder)invocationContext.getTarget()).getLoginToContinue();
        }
        Optional<LoginToContinue> optionalLoginToContinue = CdiUtils.getAnnotation(this.beanManager, this.interceptedBean.getBeanClass(), LoginToContinue.class);
        if (optionalLoginToContinue.isPresent()) {
            return optionalLoginToContinue.get();
        }
        Set bindings = (Set)invocationContext.getContextData().get("org.jboss.weld.interceptor.bindings");
        if (bindings != null && (optionalLoginToContinue = bindings.stream().filter(annotation -> annotation.annotationType().equals(LoginToContinue.class)).findAny().map(annotation -> (LoginToContinue)LoginToContinue.class.cast(annotation))).isPresent()) {
            return optionalLoginToContinue.get();
        }
        throw new IllegalStateException("@LoginToContinue not present on " + this.interceptedBean.getBeanClass());
    }

    private void saveCallerInitiatedAuthentication(HttpServletRequest request) {
        request.getSession().setAttribute(CALLER_INITIATED_AUTHENTICATION_SESSION_NAME, (Object)Boolean.TRUE);
    }

    private Boolean getCallerInitiatedAuthentication(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (Boolean)session.getAttribute(CALLER_INITIATED_AUTHENTICATION_SESSION_NAME);
    }

    private void removeCallerInitiatedAuthentication(HttpServletRequest request) {
        request.getSession().removeAttribute(CALLER_INITIATED_AUTHENTICATION_SESSION_NAME);
    }

    private void saveRequest(HttpServletRequest request) {
        request.getSession().setAttribute(ORIGINAL_REQUEST_DATA_SESSION_NAME, (Object)RequestCopier.copy(request));
    }

    private RequestData getSavedRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (RequestData)session.getAttribute(ORIGINAL_REQUEST_DATA_SESSION_NAME);
    }

    private RequestData removeSavedRequest(HttpServletRequest request) {
        RequestData requestData = this.getSavedRequest(request);
        request.getSession().removeAttribute(ORIGINAL_REQUEST_DATA_SESSION_NAME);
        return requestData;
    }

    private void saveAuthentication(HttpServletRequest request, AuthenticationData authenticationData) {
        request.getSession().setAttribute(AUTHENTICATION_DATA_SESSION_NAME, (Object)authenticationData);
    }

    private AuthenticationData getSavedAuthentication(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (AuthenticationData)session.getAttribute(AUTHENTICATION_DATA_SESSION_NAME);
    }

    private AuthenticationData removeSavedAuthentication(HttpServletRequest request) {
        AuthenticationData authenticationData = this.getSavedAuthentication(request);
        request.getSession().removeAttribute(AUTHENTICATION_DATA_SESSION_NAME);
        return authenticationData;
    }
}

