/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import java.security.PrivilegedActionException;
import org.jboss.resource.adapter.jms.util.JMSProducerUtils;

public class JMSProducerToMessageProducer
implements MessageProducer {
    private JMSProducer jmsProducer;
    private Destination destination;

    public JMSProducerToMessageProducer(JMSProducer jmsProducer, Destination destination) {
        this.jmsProducer = jmsProducer;
        this.destination = destination;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            this.jmsProducer.setDisableMessageID(value);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public boolean getDisableMessageID() throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            return this.jmsProducer.getDisableMessageID();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            this.jmsProducer.setDisableMessageTimestamp(value);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            return this.jmsProducer.getDisableMessageTimestamp();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            this.jmsProducer.setDeliveryMode(deliveryMode);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            return this.jmsProducer.getDeliveryMode();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void setPriority(int priority) throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            this.jmsProducer.setPriority(priority);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public int getPriority() throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            return this.jmsProducer.getPriority();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            this.jmsProducer.setTimeToLive(timeToLive);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public long getTimeToLive() throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            return this.jmsProducer.getTimeToLive();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            this.jmsProducer.setDeliveryDelay(deliveryDelay);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public long getDeliveryDelay() throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            return this.jmsProducer.getDeliveryDelay();
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public Destination getDestination() throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        return this.destination;
    }

    public void close() throws JMSException {
        if (this.jmsProducer != null) {
            try {
                JMSProducerUtils.close(this.jmsProducer);
            }
            catch (PrivilegedActionException ex) {
                throw (JMSException)((Object)ex.getException());
            }
        }
        this.jmsProducer = null;
        this.destination = null;
    }

    public void send(Message message) throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            this.jmsProducer.send(this.destination, message);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            int oldDeliveryMode = this.jmsProducer.getDeliveryMode();
            int oldPriority = this.jmsProducer.getPriority();
            long oldTimeToLive = this.jmsProducer.getTimeToLive();
            this.jmsProducer.setDeliveryMode(deliveryMode);
            this.jmsProducer.setPriority(priority);
            this.jmsProducer.setTimeToLive(timeToLive);
            this.jmsProducer.send(this.destination, message);
            this.jmsProducer.setDeliveryMode(oldDeliveryMode);
            this.jmsProducer.setPriority(oldPriority);
            this.jmsProducer.setTimeToLive(oldTimeToLive);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            this.jmsProducer.send(destination, message);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.jmsProducer == null) {
            throw new JMSException("JMSProducer is closed");
        }
        try {
            int oldDeliveryMode = this.jmsProducer.getDeliveryMode();
            int oldPriority = this.jmsProducer.getPriority();
            long oldTimeToLive = this.jmsProducer.getTimeToLive();
            this.jmsProducer.setDeliveryMode(deliveryMode);
            this.jmsProducer.setPriority(priority);
            this.jmsProducer.setTimeToLive(timeToLive);
            this.jmsProducer.send(destination, message);
            this.jmsProducer.setDeliveryMode(oldDeliveryMode);
            this.jmsProducer.setPriority(oldPriority);
            this.jmsProducer.setTimeToLive(oldTimeToLive);
        }
        catch (JMSRuntimeException jmsre) {
            throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
        }
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        throw new JMSException("JMSProducer does not support CompletionListener");
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new JMSException("JMSProducer does not support CompletionListener");
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        throw new JMSException("JMSProducer does not support CompletionListener");
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new JMSException("JMSProducer does not support CompletionListener");
    }
}

