/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.function.UnaryOperator;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.clustering.controller.transform.RequiredChildResourceDiscardPolicy;
import org.jboss.as.clustering.controller.transform.SimpleAttributeConverter;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.MemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MemorySizeUnit;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HeapMemoryResourceDefinition
extends MemoryResourceDefinition {
    static final PathElement PATH = HeapMemoryResourceDefinition.pathElement("heap");
    static final PathElement OBJECT_PATH = HeapMemoryResourceDefinition.pathElement("object");
    static final PathElement EVICTION_PATH = ComponentResourceDefinition.pathElement("eviction");
    static final PathElement LEGACY_PATH = PathElement.pathElement((String)EVICTION_PATH.getValue(), (String)"EVICTION");

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = HeapMemoryResourceDefinition.addChild(version, parent);
        if (InfinispanModel.VERSION_13_0_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{Attribute.SIZE_UNIT.getName()});
        }
        if (InfinispanModel.VERSION_12_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{DeprecatedAttribute.MAX_ENTRIES.getDefinition()})).end();
        }
        if (InfinispanModel.VERSION_6_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRename(MemoryResourceDefinition.Attribute.SIZE.getDefinition(), DeprecatedAttribute.MAX_ENTRIES.getName())).setValueConverter((AttributeConverter)new SimpleAttributeConverter((address, name, value, model, context) -> {
                if (!model.hasDefined(MemoryResourceDefinition.Attribute.SIZE.getName()) || model.get(MemoryResourceDefinition.Attribute.SIZE.getName()).asLong() <= 0L) {
                    value.set(EvictionStrategy.NONE.name());
                } else {
                    value.set("LRU");
                }
            }), new String[]{DeprecatedAttribute.STRATEGY.getName()})).end();
        }
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().setValueConverter((AttributeConverter)new SimpleAttributeConverter((address, name, value, model, context) -> {
                if (value.isDefined()) {
                    value.set(value.asInt());
                }
            }), new AttributeDefinition[]{MemoryResourceDefinition.Attribute.SIZE.getDefinition(), DeprecatedAttribute.MAX_ENTRIES.getDefinition()});
        }
    }

    static ResourceTransformationDescriptionBuilder addChild(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            return parent.addChildRedirection(PATH, LEGACY_PATH, (DynamicDiscardPolicy)RequiredChildResourceDiscardPolicy.NEVER);
        }
        if (InfinispanModel.VERSION_6_0_0.requiresTransformation(version)) {
            return parent.addChildRedirection(PATH, EVICTION_PATH, (DynamicDiscardPolicy)RequiredChildResourceDiscardPolicy.NEVER);
        }
        if (InfinispanModel.VERSION_13_0_0.requiresTransformation(version)) {
            return parent.addChildRedirection(PATH, OBJECT_PATH);
        }
        return parent.addChildResource(PATH);
    }

    HeapMemoryResourceDefinition() {
        super(StorageType.HEAP, PATH, new ResourceDescriptorConfigurator(), Attribute.SIZE_UNIT);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        parent.registerAlias(OBJECT_PATH, (AliasEntry)new SimpleAliasEntry((org.jboss.as.controller.registry.ManagementResourceRegistration)registration));
        parent.registerAlias(EVICTION_PATH, (AliasEntry)new SimpleAliasEntry((org.jboss.as.controller.registry.ManagementResourceRegistration)registration));
        parent.registerAlias(LEGACY_PATH, (AliasEntry)new SimpleAliasEntry((org.jboss.as.controller.registry.ManagementResourceRegistration)registration));
        return registration;
    }

    static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        ResourceDescriptorConfigurator() {
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return descriptor.addAttributes(Attribute.class).addIgnoredAttributes(EnumSet.complementOf(EnumSet.of(DeprecatedAttribute.MAX_ENTRIES))).addAlias((org.jboss.as.clustering.controller.Attribute)DeprecatedAttribute.MAX_ENTRIES, (org.jboss.as.clustering.controller.Attribute)MemoryResourceDefinition.Attribute.SIZE);
        }
    }

    static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        STRATEGY("strategy", ModelType.STRING, new ModelNode(EvictionStrategy.NONE.name())),
        MAX_ENTRIES("max-entries", ModelType.LONG, new ModelNode(-1L));

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).setDeprecated(InfinispanModel.VERSION_6_0_0.getVersion())).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        SIZE_UNIT(MemoryResourceDefinition.SharedAttribute.SIZE_UNIT){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(MemorySizeUnit.class, EnumSet.of(MemorySizeUnit.ENTRIES)));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(org.jboss.as.clustering.controller.Attribute basis) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply(new SimpleAttributeDefinitionBuilder((SimpleAttributeDefinition)basis.getDefinition()))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

