/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging.engines;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.util.TransportTimer;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.AtomicTransactionConstants;
import com.arjuna.webservices11.wsat.CoordinatorInboundEvents;
import com.arjuna.webservices11.wsat.State;
import com.arjuna.webservices11.wsat.client.ParticipantClient;
import com.arjuna.webservices11.wsat.processors.CoordinatorProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.util.TimerTask;
import javax.xml.namespace.QName;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;

public class CoordinatorEngine
implements CoordinatorInboundEvents {
    private final boolean durable;
    private final String id;
    private final InstanceIdentifier instanceIdentifier;
    private final W3CEndpointReference participant;
    private State state;
    private boolean recovered;
    private boolean readOnly;
    private TimerTask timerTask;

    public CoordinatorEngine(String id, boolean durable, W3CEndpointReference participant) {
        this(id, durable, participant, false, State.STATE_ACTIVE);
    }

    public CoordinatorEngine(String id, boolean durable, W3CEndpointReference participant, boolean recovered, State state) {
        this.id = id;
        this.instanceIdentifier = new InstanceIdentifier(id);
        this.durable = durable;
        this.participant = participant;
        this.state = state;
        this.recovered = recovered;
        if (!recovered || state == State.STATE_PREPARED_SUCCESS) {
            CoordinatorProcessor.getProcessor().activateCoordinator(this, id);
        }
    }

    @Override
    public synchronized void aborted(Notification aborted, MAP map, ArjunaContext arjunaContext) {
        State current = this.state;
        if (current == State.STATE_ACTIVE) {
            this.changeState(State.STATE_ABORTING);
        } else if (current == State.STATE_PREPARING || current == State.STATE_ABORTING) {
            this.forget();
        }
    }

    @Override
    public synchronized void committed(Notification committed, MAP map, ArjunaContext arjunaContext) {
        State current = this.state;
        if (current == State.STATE_ACTIVE) {
            this.changeState(State.STATE_ABORTING);
        } else if (current == State.STATE_PREPARING || current == State.STATE_COMMITTING) {
            this.forget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepared(Notification prepared, MAP map, ArjunaContext arjunaContext) {
        State current;
        CoordinatorEngine coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_ABORTING);
            } else if (current == State.STATE_PREPARING) {
                this.changeState(State.STATE_PREPARED_SUCCESS);
            }
        }
        if (current == State.STATE_COMMITTING) {
            this.sendCommit();
        } else if (current == State.STATE_ABORTING) {
            if (this.durable) {
                this.sendRollback();
            } else {
                this.sendUnknownTransaction(map, arjunaContext);
            }
            this.forget();
        } else if (current == null && !this.readOnly) {
            if (this.durable) {
                this.sendRollback();
            } else {
                this.sendUnknownTransaction(map, arjunaContext);
            }
        }
    }

    @Override
    public synchronized void readOnly(Notification readOnly, MAP map, ArjunaContext arjunaContext) {
        State current = this.state;
        if (current == State.STATE_ACTIVE || current == State.STATE_PREPARING || current == State.STATE_ABORTING) {
            if (current != State.STATE_ABORTING) {
                this.readOnly = true;
            }
            this.forget();
        }
    }

    @Override
    public void soapFault(SoapFault soapFault, MAP map, ArjunaContext arjunaContext) {
        if (WSTLogger.logger.isTraceEnabled()) {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            SoapFaultType soapFaultType = soapFault.getSoapFaultType();
            QName subCode = soapFault.getSubcode();
            WSTLogger.logger.tracev("Unexpected SOAP fault for coordinator {0}: {1} {2}", new Object[]{instanceIdentifier, soapFaultType, subCode});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State prepare() {
        State current;
        CoordinatorEngine coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_PREPARING);
            }
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_PREPARING) {
            this.sendPrepare();
        }
        this.waitForState(State.STATE_PREPARING, TransportTimer.getTransportTimeout());
        coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            if (this.state != State.STATE_PREPARING) {
                return this.state;
            }
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State commit() {
        State current;
        CoordinatorEngine coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            current = this.state;
            if (current == State.STATE_PREPARED_SUCCESS) {
                this.changeState(State.STATE_COMMITTING);
            }
        }
        if (current == State.STATE_PREPARED_SUCCESS || current == State.STATE_COMMITTING) {
            this.sendCommit();
        }
        this.waitForState(State.STATE_COMMITTING, TransportTimer.getTransportTimeout());
        coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            if (this.state != State.STATE_COMMITTING) {
                if (this.recovered) {
                    CoordinatorProcessor.getProcessor().deactivateCoordinator(this);
                }
                return this.state;
            }
            this.recovered = true;
            return State.STATE_COMMITTING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State rollback() {
        State current;
        CoordinatorEngine coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE || current == State.STATE_PREPARING || current == State.STATE_PREPARED_SUCCESS) {
                this.changeState(State.STATE_ABORTING);
            }
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_PREPARING || current == State.STATE_PREPARED_SUCCESS) {
            this.sendRollback();
        } else if (current == State.STATE_ABORTING) {
            this.forget();
        }
        this.waitForState(State.STATE_ABORTING, TransportTimer.getTransportTimeout());
        coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            if (this.state != State.STATE_ABORTING) {
                return this.state;
            }
            this.forget();
            return State.STATE_ABORTING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commsTimeout(TimerTask caller) {
        State current;
        CoordinatorEngine coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            if (this.timerTask != caller) {
                return;
            }
            current = this.state;
        }
        if (current == State.STATE_PREPARING) {
            this.sendPrepare();
        } else if (current == State.STATE_COMMITTING) {
            this.sendCommit();
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public W3CEndpointReference getParticipant() {
        return this.participant;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized State getState() {
        return this.state;
    }

    private synchronized void changeState(State state) {
        if (this.state != state) {
            this.state = state;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private State waitForState(State origState, long delay) {
        long end = System.currentTimeMillis() + delay;
        CoordinatorEngine coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            long remaining;
            while (this.state == origState && (remaining = end - System.currentTimeMillis()) > 0L) {
                try {
                    this.wait(remaining);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.state;
        }
    }

    private void forget() {
        this.changeState(null);
        if (!this.recovered) {
            CoordinatorProcessor.getProcessor().deactivateCoordinator(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPrepare() {
        CoordinatorEngine coordinatorEngine;
        TimerTask newTimerTask;
        block12: {
            newTimerTask = this.createTimerTask();
            coordinatorEngine = this;
            synchronized (coordinatorEngine) {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                this.timerTask = newTimerTask;
            }
            try {
                ParticipantClient.getClient().sendPrepare(this.participant, this.createContext(), this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block12;
                WSTLogger.logger.tracev("Unexpecting exception while sending Prepare", (Object)th);
            }
        }
        coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            if (this.timerTask != null && this.timerTask.equals(newTimerTask)) {
                if (this.state == State.STATE_PREPARING) {
                    this.scheduleTimer(newTimerTask);
                } else {
                    this.timerTask = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommit() {
        CoordinatorEngine coordinatorEngine;
        TimerTask newTimerTask;
        block12: {
            newTimerTask = this.createTimerTask();
            coordinatorEngine = this;
            synchronized (coordinatorEngine) {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                this.timerTask = newTimerTask;
            }
            try {
                ParticipantClient.getClient().sendCommit(this.participant, this.createContext(), this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block12;
                WSTLogger.logger.tracev("Unexpecting exception while sending Commit", (Object)th);
            }
        }
        coordinatorEngine = this;
        synchronized (coordinatorEngine) {
            if (this.timerTask != null && this.timerTask.equals(newTimerTask)) {
                if (this.state == State.STATE_COMMITTING) {
                    this.scheduleTimer(newTimerTask);
                } else {
                    this.timerTask = null;
                }
            }
        }
    }

    private void sendRollback() {
        block2: {
            try {
                ParticipantClient.getClient().sendRollback(this.participant, this.createContext(), this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpecting exception while sending Rollback", (Object)th);
            }
        }
    }

    private void sendUnknownTransaction(MAP map, ArjunaContext arjunaContext) {
        try {
            MAP faultMAP = AddressingHelper.createFaultContext(map, MessageId.getMessageId());
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            String message = WSTLogger.i18NLogger.get_wst11_messaging_engines_CoordinatorEngine_sendUnknownTransaction_1();
            SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, AtomicTransactionConstants.WSAT_ERROR_CODE_UNKNOWN_TRANSACTION_QNAME, message);
            ParticipantClient.getClient().sendSoapFault(faultMAP, soapFault, instanceIdentifier);
        }
        catch (Throwable th) {
            WSTLogger.i18NLogger.warn_wst11_messaging_engines_CoordinatorEngine_sendUnknownTransaction_2(this.id, th);
        }
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                CoordinatorEngine.this.commsTimeout(this);
            }
        };
    }

    private void scheduleTimer(TimerTask timerTask) {
        TransportTimer.getTimer().schedule(timerTask, TransportTimer.getTransportPeriod());
    }

    private MAP createContext() {
        String messageId = MessageId.getMessageId();
        return AddressingHelper.createNotificationContext(messageId);
    }
}

