/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import jakarta.servlet.ServletContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Optional;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyConfig {
    private static final Method GET_CONFIG;
    private static final Method GET_OPTIONAL_VALUE;
    private static final Method GET_PROPERTY_NAMES;
    private Object config;

    public ResteasyConfig() {
        if (GET_CONFIG != null) {
            try {
                this.config = GET_CONFIG.invoke(null, ResteasyConfig.getClassLoader());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getValue(String propertyName) {
        if (this.config == null) {
            return null;
        }
        try {
            Optional opt = (Optional)GET_OPTIONAL_VALUE.invoke(this.config, propertyName, String.class);
            return opt.orElse(null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LogMessages.LOGGER.debugf(e, "Failed to invoke the configuration API method %s.", GET_OPTIONAL_VALUE);
            return null;
        }
    }

    public String getValue(String propertyName, SOURCE source) {
        return this.getValue(propertyName, source, null);
    }

    public String getValue(final String propertyName, final SOURCE source, final String defaultValue) {
        if (System.getSecurityManager() == null) {
            return this.getValue0(propertyName, source, defaultValue);
        }
        String value = null;
        try {
            value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return ResteasyConfig.this.getValue0(propertyName, source, defaultValue);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae);
        }
        return value;
    }

    public String getValue0(String propertyName, SOURCE source, String defaultValue) {
        if (this.config == null) {
            switch (source) {
                case SYSTEM: {
                    return System.getProperty(propertyName, defaultValue);
                }
                case ENV: {
                    String value = System.getenv(propertyName);
                    return value != null ? value : defaultValue;
                }
                case SERVLET_CONTEXT: {
                    ServletContext context = ResteasyProviderFactory.getContextData(ServletContext.class);
                    if (context != null) {
                        String value = context.getInitParameter(propertyName);
                        return value != null ? value : defaultValue;
                    }
                    return defaultValue;
                }
            }
            throw new RuntimeException(Messages.MESSAGES.unknownEnumerationValue(source.toString()));
        }
        try {
            Optional opt = (Optional)GET_OPTIONAL_VALUE.invoke(this.config, propertyName, String.class);
            return opt.orElse(defaultValue);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LogMessages.LOGGER.debugf(e, "Failed to invoke the configuration API method %s.", GET_OPTIONAL_VALUE);
            return defaultValue;
        }
    }

    public Iterable<String> getPropertyNames() {
        return this.config == null ? null : this.getPropertyNames0();
    }

    public Iterable<String> getPropertyNames0() {
        if (System.getSecurityManager() == null) {
            try {
                return (Iterable)GET_PROPERTY_NAMES.invoke(this.config, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LogMessages.LOGGER.debugf(e, "Failed to invoke the configuration API method %s.", GET_PROPERTY_NAMES);
                return null;
            }
        }
        Iterable<String> value = null;
        try {
            value = AccessController.doPrivileged(new PrivilegedExceptionAction<Iterable<String>>(){

                @Override
                public Iterable<String> run() throws Exception {
                    try {
                        return (Iterable)GET_PROPERTY_NAMES.invoke(ResteasyConfig.this.config, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        LogMessages.LOGGER.debugf(e, "Failed to invoke the configuration API method %s.", GET_PROPERTY_NAMES);
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae);
        }
        return value;
    }

    private static ClassLoader getClassLoader() {
        if (System.getSecurityManager() == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            return tccl != null ? tccl : ResteasyConfig.class.getClassLoader();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                    return tccl != null ? tccl : ResteasyConfig.class.getClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(Messages.MESSAGES.unableToFindClassloader(ResteasyConfig.class.getName()));
        }
    }

    static {
        Method getPropertyNames;
        Method getOptionalValue;
        Method getConfig;
        try {
            ClassLoader classLoader = ResteasyConfig.getClassLoader();
            Class<?> configProvider = Class.forName("org.eclipse.microprofile.config.ConfigProvider", false, classLoader);
            getConfig = configProvider.getDeclaredMethod("getConfig", ClassLoader.class);
            Class<?> clazz = Class.forName("org.eclipse.microprofile.config.Config", false, classLoader);
            getOptionalValue = clazz.getDeclaredMethod("getOptionalValue", String.class, Class.class);
            getPropertyNames = clazz.getDeclaredMethod("getPropertyNames", new Class[0]);
            Class.forName("org.jboss.resteasy.microprofile.config.ServletConfigSourceImpl", false, classLoader);
        }
        catch (Throwable ignore) {
            getConfig = null;
            getOptionalValue = null;
            getPropertyNames = null;
        }
        GET_CONFIG = getConfig;
        GET_OPTIONAL_VALUE = getOptionalValue;
        GET_PROPERTY_NAMES = getPropertyNames;
    }

    public static enum SOURCE {
        SYSTEM,
        ENV,
        SERVLET_CONTEXT;

    }
}

