/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.utils.JsonLoader;

public abstract class ActiveMQAbstractView<T> {
    private static final String FILTER_FIELD = "field";
    private static final String FILTER_OPERATION = "operation";
    private static final String FILTER_VALUE = "value";
    private static final String SORT_ORDER = "sortOrder";
    private static final String SORT_COLUMN = "sortColumn";
    protected Collection<T> collection;
    protected ActiveMQFilterPredicate<T> predicate;
    protected String sortColumn = this.getDefaultOrderColumn();
    protected String sortOrder = "asc";
    protected String options;

    public void setCollection(Collection<T> collection) {
        this.collection = collection;
    }

    public String getResultsAsJson(int page, int pageSize) {
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder();
        JsonArrayBuilder array = JsonLoader.createArrayBuilder();
        this.collection = this.collection.stream().filter(this.getPredicate()).collect(Collectors.toList());
        for (T element : this.getPagedResult(page, pageSize)) {
            JsonObjectBuilder jsonObjectBuilder = this.toJson(element);
            if (jsonObjectBuilder == null) continue;
            array.add(jsonObjectBuilder);
        }
        obj.add("data", array);
        obj.add("count", this.collection.size());
        return obj.build().toString();
    }

    public List<T> getPagedResult(int page, int pageSize) {
        ArrayList builder = new ArrayList();
        int start = (page - 1) * pageSize;
        int end = Math.min(page * pageSize, this.collection.size());
        int i = 0;
        for (Object e : this.collection.stream().sorted(this.getComparator()).collect(Collectors.toList())) {
            if (i >= start && i < end) {
                builder.add(e);
            }
            ++i;
        }
        return Collections.unmodifiableList(builder);
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }

    public Comparator<T> getComparator() {
        return (left, right) -> {
            try {
                Object leftValue = this.getField(left, this.sortColumn);
                Object rightValue = this.getField(right, this.sortColumn);
                if (leftValue instanceof Comparable && rightValue instanceof Comparable) {
                    if (this.sortOrder.equals("desc")) {
                        return ((Comparable)rightValue).compareTo(leftValue);
                    }
                    return ((Comparable)leftValue).compareTo(rightValue);
                }
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        };
    }

    abstract Object getField(T var1, String var2);

    public void setOptions(String options) {
        JsonObject json = JsonUtil.readJsonObject((String)options);
        if (this.predicate != null) {
            this.predicate.setField(json.getString(FILTER_FIELD));
            this.predicate.setOperation(json.getString(FILTER_OPERATION));
            this.predicate.setValue(json.getString(FILTER_VALUE));
            if (json.containsKey((Object)SORT_COLUMN) && json.containsKey((Object)SORT_ORDER)) {
                this.sortColumn = json.getString(SORT_COLUMN);
                this.sortOrder = json.getString(SORT_ORDER);
            }
        }
    }

    public abstract Class getClassT();

    public abstract JsonObjectBuilder toJson(T var1);

    public abstract String getDefaultOrderColumn();

    protected String toString(Object o) {
        return o == null ? "" : o.toString();
    }
}

