/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionPredicate;
import org.wildfly.common.function.Functions;
import protostream.com.google.protobuf.CodedOutputStream;

public class FunctionalScalarMarshaller<T, V>
implements ProtoStreamMarshaller<T> {
    private static final int VALUE_INDEX = 1;
    private final Class<? extends T> targetClass;
    private final Supplier<T> defaultFactory;
    private final ExceptionPredicate<T, IOException> skipWrite;
    private final ScalarMarshaller<V> marshaller;
    private final ExceptionFunction<T, V, IOException> function;
    private final ExceptionFunction<V, T, IOException> factory;

    public FunctionalScalarMarshaller(ScalarMarshaller<V> marshaller, Supplier<T> defaultFactory, ExceptionFunction<T, V, IOException> function, ExceptionFunction<V, T, IOException> factory) {
        this(defaultFactory.get().getClass(), marshaller, defaultFactory, function, factory);
    }

    public FunctionalScalarMarshaller(ScalarMarshaller<V> marshaller, Supplier<T> defaultFactory, BiPredicate<V, V> equals, ExceptionFunction<T, V, IOException> function, ExceptionFunction<V, T, IOException> factory) {
        this(defaultFactory.get().getClass(), marshaller, defaultFactory, equals, function, factory);
    }

    public FunctionalScalarMarshaller(ScalarMarshaller<V> marshaller, Supplier<T> defaultFactory, ExceptionPredicate<T, IOException> skipWrite, ExceptionFunction<T, V, IOException> function, ExceptionFunction<V, T, IOException> factory) {
        this(defaultFactory.get().getClass(), marshaller, defaultFactory, skipWrite, function, factory);
    }

    public FunctionalScalarMarshaller(Class<? extends T> targetClass, ScalarMarshaller<V> marshaller, ExceptionFunction<T, V, IOException> function, ExceptionFunction<V, T, IOException> factory) {
        this(targetClass, marshaller, Functions.constantSupplier(null), Objects::isNull, function, factory);
    }

    public FunctionalScalarMarshaller(Class<? extends T> targetClass, ScalarMarshaller<V> marshaller, Supplier<T> defaultFactory, ExceptionFunction<T, V, IOException> function, ExceptionFunction<V, T, IOException> factory) {
        this(targetClass, marshaller, defaultFactory, Objects::equals, function, factory);
    }

    public FunctionalScalarMarshaller(Class<? extends T> targetClass, ScalarMarshaller<V> marshaller, final Supplier<T> defaultFactory, final BiPredicate<V, V> equals, final ExceptionFunction<T, V, IOException> function, ExceptionFunction<V, T, IOException> factory) {
        this(targetClass, marshaller, defaultFactory, new ExceptionPredicate<T, IOException>(){

            public boolean test(T value) throws IOException {
                return equals.test(function.apply(value), function.apply(defaultFactory.get()));
            }
        }, function, factory);
    }

    public FunctionalScalarMarshaller(Class<? extends T> targetClass, ScalarMarshaller<V> marshaller, Supplier<T> defaultFactory, ExceptionPredicate<T, IOException> skipWrite, ExceptionFunction<T, V, IOException> function, ExceptionFunction<V, T, IOException> factory) {
        this.targetClass = targetClass;
        this.defaultFactory = defaultFactory;
        this.skipWrite = skipWrite;
        this.marshaller = marshaller;
        this.function = function;
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        Object value = this.defaultFactory.get();
        boolean reading = true;
        block3: while (reading) {
            int tag = reader.readTag();
            switch (WireFormat.getTagFieldNumber((int)tag)) {
                case 1: {
                    value = this.factory.apply(this.marshaller.readFrom(reader));
                    continue block3;
                }
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return value;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T value) throws IOException {
        if (!this.skipWrite.test(value)) {
            writer.writeTag(1, this.marshaller.getWireType());
            this.marshaller.writeTo(writer, this.function.apply(value));
        }
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, T value) {
        try {
            int size = 0;
            if (!this.skipWrite.test(value)) {
                OptionalInt valueSize = this.marshaller.size(context, this.function.apply(value));
                if (valueSize.isPresent()) {
                    size += CodedOutputStream.computeTagSize((int)1) + valueSize.getAsInt();
                } else {
                    return valueSize;
                }
            }
            return OptionalInt.of(size);
        }
        catch (IOException e) {
            return OptionalInt.empty();
        }
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

