/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigInjectionBean;
import io.smallrye.config.inject.ConfigMappingInjectionBean;
import io.smallrye.config.inject.ConfigProducer;
import io.smallrye.config.inject.ConfigProducerUtil;
import io.smallrye.config.inject.InjectionMessages;
import io.smallrye.config.inject.SecuritySupport;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.inject.Provider;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigExtension
implements Extension {
    private final Set<InjectionPoint> configPropertyInjectionPoints = new HashSet<InjectionPoint>();
    private final Set<AnnotatedType<?>> configMappings = new HashSet();
    private final Set<InjectionPoint> configMappingInjectionPoints = new HashSet<InjectionPoint>();

    protected void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        AnnotatedType configBean = bm.createAnnotatedType(ConfigProducer.class);
        bbd.addAnnotatedType(configBean, ConfigProducer.class.getName());
    }

    protected void processConfigMappings(@Observes @WithAnnotations(value={ConfigProperties.class, ConfigMapping.class}) ProcessAnnotatedType<?> processAnnotatedType) {
        if (processAnnotatedType.getAnnotatedType().isAnnotationPresent(ConfigProperties.class) || processAnnotatedType.getAnnotatedType().isAnnotationPresent(ConfigMapping.class)) {
            processAnnotatedType.veto();
            this.configMappings.add(processAnnotatedType.getAnnotatedType());
        }
    }

    protected void collectConfigPropertyInjectionPoints(@Observes ProcessInjectionPoint<?, ?> pip) {
        if (pip.getInjectionPoint().getAnnotated().isAnnotationPresent(ConfigProperty.class)) {
            this.configPropertyInjectionPoints.add(pip.getInjectionPoint());
        }
        if (pip.getInjectionPoint().getAnnotated().isAnnotationPresent(ConfigProperties.class) || pip.getInjectionPoint().getAnnotated().isAnnotationPresent(ConfigMapping.class)) {
            this.configMappingInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    protected void registerCustomBeans(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        HashSet<Class> customTypes = new HashSet<Class>();
        for (InjectionPoint ip : this.configPropertyInjectionPoints) {
            Type requiredType = ip.getType();
            if (requiredType instanceof ParameterizedType) {
                Type typeArgument;
                ParameterizedType type = (ParameterizedType)requiredType;
                if (!type.getRawType().equals(Provider.class) && !type.getRawType().equals(Instance.class) || !((typeArgument = type.getActualTypeArguments()[0]) instanceof Class) || ConfigProducer.isClassHandledByConfigProducer(typeArgument)) continue;
                customTypes.add((Class)typeArgument);
                continue;
            }
            if (!(requiredType instanceof Class) || ConfigProducer.isClassHandledByConfigProducer(requiredType)) continue;
            customTypes.add((Class)requiredType);
        }
        customTypes.stream().map(customType -> new ConfigInjectionBean(bm, (Class<?>)customType)).forEach(arg_0 -> ((AfterBeanDiscovery)abd).addBean(arg_0));
        this.configMappings.stream().map(annotatedType -> new ConfigMappingInjectionBean(bm, annotatedType)).forEach(arg_0 -> ((AfterBeanDiscovery)abd).addBean(arg_0));
    }

    protected void validate(@Observes AfterDeploymentValidation adv) {
        Config config = ConfigProvider.getConfig((ClassLoader)SecuritySupport.getContextClassLoader());
        Set configNames = StreamSupport.stream(config.getPropertyNames().spliterator(), false).collect(Collectors.toSet());
        for (InjectionPoint injectionPoint : this.getConfigPropertyInjectionPoints()) {
            String name;
            Type type = injectionPoint.getType();
            if (type instanceof Class && ConfigValue.class.isAssignableFrom((Class)type) || type instanceof Class && OptionalInt.class.isAssignableFrom((Class)type) || type instanceof Class && OptionalLong.class.isAssignableFrom((Class)type) || type instanceof Class && OptionalDouble.class.isAssignableFrom((Class)type) || type instanceof ParameterizedType && (Optional.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) || Provider.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) || Supplier.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()))) continue;
            ConfigProperty configProperty = (ConfigProperty)injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
            try {
                name = ConfigProducerUtil.getConfigKey(injectionPoint, configProperty);
            }
            catch (IllegalStateException e) {
                adv.addDeploymentProblem((Throwable)e);
                continue;
            }
            if (!configNames.contains(name) && ConfigProducerUtil.getRawValue(name, config) == null && configProperty.defaultValue().equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                adv.addDeploymentProblem((Throwable)InjectionMessages.msg.noConfigValue(name));
                continue;
            }
            try {
                ConfigProducerUtil.getValue(injectionPoint, config);
            }
            catch (IllegalArgumentException e) {
                adv.addDeploymentProblem((Throwable)InjectionMessages.msg.illegalConversion(name, type));
            }
        }
        HashSet<ConfigMappings.ConfigMappingWithPrefix> configMappingsWithPrefix = new HashSet<ConfigMappings.ConfigMappingWithPrefix>();
        for (AnnotatedType<?> annotatedType : this.configMappings) {
            configMappingsWithPrefix.add(ConfigMappings.ConfigMappingWithPrefix.configMappingWithPrefix((Class)annotatedType.getJavaClass(), (String)ConfigMappingInjectionBean.getPrefixFromType(annotatedType)));
        }
        for (InjectionPoint injectionPoint : this.configMappingInjectionPoints) {
            ConfigMappingInjectionBean.getPrefixFromInjectionPoint(injectionPoint).ifPresent(prefix -> configMappingsWithPrefix.add(ConfigMappings.ConfigMappingWithPrefix.configMappingWithPrefix((Class)((Class)injectionPoint.getType()), (String)prefix)));
        }
        try {
            ConfigMappings.registerConfigMappings((SmallRyeConfig)((SmallRyeConfig)config), configMappingsWithPrefix);
        }
        catch (ConfigValidationException configValidationException) {
            adv.addDeploymentProblem((Throwable)configValidationException);
        }
    }

    protected Set<InjectionPoint> getConfigPropertyInjectionPoints() {
        return this.configPropertyInjectionPoints;
    }
}

