/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.eesecurity;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.DotName;

class EESecurityAnnotationProcessor
implements DeploymentUnitProcessor {
    static final AttachmentKey<Boolean> SECURITY_PRESENT = AttachmentKey.create(Boolean.class);
    static final DotName[] ANNOTATIONS = new DotName[]{DotName.createSimple((String)"jakarta.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition"), DotName.createSimple((String)"jakarta.security.enterprise.authentication.mechanism.http.CustomFormAuthenticationMechanismDefinition"), DotName.createSimple((String)"jakarta.security.enterprise.authentication.mechanism.http.FormAuthenticationMechanismDefinition"), DotName.createSimple((String)"jakarta.security.enterprise.identitystore.DatabaseIdentityStoreDefinition"), DotName.createSimple((String)"jakarta.security.enterprise.identitystore.LdapIdentityStoreDefinition")};
    static final DotName[] INTERFACES = new DotName[]{DotName.createSimple((String)"jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism"), DotName.createSimple((String)"jakarta.security.enterprise.identitystore.IdentityStoreHandler"), DotName.createSimple((String)"jakarta.security.enterprise.identitystore.IdentityStore"), DotName.createSimple((String)"jakarta.security.enterprise.identitystore.RememberMeIdentityStore")};

    EESecurityAnnotationProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (DotName annotation : ANNOTATIONS) {
            if (index.getAnnotations(annotation).isEmpty()) continue;
            this.markAsEESecurity(deploymentUnit);
            return;
        }
        for (DotName annotation : INTERFACES) {
            if (index.getAllKnownImplementors(annotation).isEmpty()) continue;
            this.markAsEESecurity(deploymentUnit);
            return;
        }
    }

    private void markAsEESecurity(DeploymentUnit deploymentUnit) {
        DeploymentUnit top = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        top.putAttachment(SECURITY_PRESENT, (Object)true);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

