/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutEvents;
import io.smallrye.faulttolerance.core.timeout.TimeoutLogger;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class AsyncTimeout<V>
implements FaultToleranceStrategy<Future<V>> {
    private final FaultToleranceStrategy<Future<V>> delegate;
    private final Executor executor;

    public AsyncTimeout(Timeout<Future<V>> delegate, Executor executor) {
        this.delegate = delegate;
        this.executor = Preconditions.checkNotNull(executor, "Executor must be set");
    }

    @Override
    public Future<V> apply(InvocationContext<Future<V>> ctx) throws Exception {
        TimeoutLogger.LOG.trace("AsyncTimeout started");
        try {
            Future<V> future = this.doApply(ctx);
            return future;
        }
        finally {
            TimeoutLogger.LOG.trace("AsyncTimeout finished");
        }
    }

    private Future<V> doApply(InvocationContext<Future<V>> ctx) throws Exception {
        AsyncTimeoutTask<Future> task = new AsyncTimeoutTask<Future>(() -> this.delegate.apply(ctx));
        ctx.registerEventHandler(TimeoutEvents.AsyncTimedOut.class, task::timedOut);
        this.executor.execute(task);
        try {
            return (Future)task.get();
        }
        catch (ExecutionException e) {
            throw SneakyThrow.sneakyThrow(e.getCause());
        }
    }

    private static class AsyncTimeoutTask<T>
    extends FutureTask<T> {
        AsyncTimeoutTask(Callable<T> callable) {
            super(callable);
        }

        public void timedOut(TimeoutEvents.AsyncTimedOut event) {
            super.setException((Throwable)event.timeoutException());
        }
    }
}

