/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.annotations.security.doseta.Verifications;
import org.jboss.resteasy.annotations.security.doseta.Verify;
import org.jboss.resteasy.security.doseta.AbstractDigitalVerificationHeaderDecorator;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.security.doseta.UnauthorizedSignatureException;
import org.jboss.resteasy.security.doseta.VerificationResults;
import org.jboss.resteasy.security.doseta.Verifier;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
public class ServerDigitalVerificationHeaderDecoratorFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext configurable) {
        Verify verify = resourceInfo.getResourceMethod().getAnnotation(Verify.class);
        Verifications verifications = resourceInfo.getResourceClass().getAnnotation(Verifications.class);
        resourceInfo.getResourceMethod();
        if (verify != null || verifications != null) {
            configurable.register((Object)new DigitalVerificationHeaderDecorator(verify, verifications, ServerDigitalVerificationHeaderDecoratorFeature.hasEntityParameter(resourceInfo.getResourceMethod())));
        }
    }

    static boolean hasEntityParameter(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            boolean match = false;
            for (int j = 0; j < annotations[i].length; ++j) {
                if (!annotations[i][j].annotationType().equals(MatrixParam.class) && !annotations[i][j].annotationType().equals(QueryParam.class) && !annotations[i][j].annotationType().equals(PathParam.class) && !annotations[i][j].annotationType().equals(CookieParam.class) && !annotations[i][j].annotationType().equals(HeaderParam.class) && !annotations[i][j].annotationType().equals(Context.class) && !annotations[i][j].annotationType().equals(FormParam.class)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return true;
        }
        return false;
    }

    protected static void verify(ContainerRequestContext context, Verifier verifier) {
        VerificationResults results;
        MultivaluedMap headers = context.getHeaders();
        List strings = (List)headers.get((Object)"DKIM-Signature");
        if (strings == null) {
            throw new UnauthorizedSignatureException(Messages.MESSAGES.thereWasNoSignatureHeader("DKIM-Signature"));
        }
        ArrayList<DKIMSignature> signatures = new ArrayList<DKIMSignature>();
        for (String headerVal : strings) {
            try {
                signatures.add(new DKIMSignature(headerVal));
            }
            catch (Exception e) {
                throw new UnauthorizedSignatureException(Messages.MESSAGES.malformedSignatureHeader("DKIM-Signature"));
            }
        }
        if (verifier.getRepository() == null) {
            KeyRepository repository = (KeyRepository)context.getProperty(KeyRepository.class.getName());
            if (repository == null) {
                repository = (KeyRepository)ResteasyProviderFactory.getContextData(KeyRepository.class);
            }
            verifier.setRepository(repository);
        }
        if (!(results = verifier.verify(signatures, (Map)headers, null)).isVerified()) {
            throw new UnauthorizedSignatureException(results);
        }
    }

    @Priority(value=3000)
    public static class DigitalVerificationHeaderDecorator
    extends AbstractDigitalVerificationHeaderDecorator
    implements ContainerRequestFilter {
        protected boolean hasEntityParameter;

        public DigitalVerificationHeaderDecorator(Verify verify, Verifications verifications, boolean hasEntityParameter) {
            this.verify = verify;
            this.verifications = verifications;
            this.hasEntityParameter = hasEntityParameter;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            if (this.hasEntityParameter) {
                requestContext.setProperty(Verifier.class.getName(), (Object)this.create());
            } else {
                ServerDigitalVerificationHeaderDecoratorFeature.verify(requestContext, this.create());
            }
        }
    }
}

