/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.spi.JsonProvider;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class JsonLoader {
    private static final JsonProvider provider = JsonLoader.loadProvider();

    private static JsonProvider loadProvider() {
        return AccessController.doPrivileged(new PrivilegedAction<JsonProvider>(){

            @Override
            public JsonProvider run() {
                ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(JsonLoader.class.getClassLoader());
                    JsonProvider jsonProvider = JsonProvider.provider();
                    return jsonProvider;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalLoader);
                }
            }
        });
    }

    public static JsonObject readObject(Reader reader) {
        try (JsonReader jsonReader = provider.createReader(reader);){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }

    public static JsonArray readArray(Reader reader) {
        try (JsonReader jsonReader = provider.createReader(reader);){
            JsonArray jsonArray = jsonReader.readArray();
            return jsonArray;
        }
    }

    public static JsonArrayBuilder createArrayBuilder() {
        return provider.createArrayBuilder();
    }

    public static JsonObjectBuilder createObjectBuilder() {
        return provider.createObjectBuilder();
    }
}

