/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.tag.AbstractTagLibrary;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.facelets.tag.jsf.LazyTagLibrary;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompositeComponentTagLibrary
extends LazyTagLibrary {
    private static final Logger LOGGER = FacesLogger.FACELETS_COMPONENT.getLogger();
    private String ns = null;
    private String compositeLibraryName;
    private boolean enableMissingResourceLibraryDetection;
    private static final String NS_COMPOSITE_COMPONENT_PREFIX = "http://java.sun.com/jsf/composite/";
    private static final String XMLNS_COMPOSITE_COMPONENT_PREFIX = "http://xmlns.jcp.org/jsf/composite/";

    public CompositeComponentTagLibrary(String ns) {
        super(ns);
        if (null == ns) {
            throw new NullPointerException();
        }
        this.ns = ns;
        this.init();
    }

    public CompositeComponentTagLibrary(String ns, String compositeLibraryName) {
        super(ns);
        if (null == ns) {
            throw new NullPointerException();
        }
        this.ns = ns;
        if (null == compositeLibraryName) {
            throw new NullPointerException();
        }
        this.compositeLibraryName = compositeLibraryName;
        this.init();
    }

    private void init() {
        WebConfiguration webconfig = WebConfiguration.getInstance();
        this.enableMissingResourceLibraryDetection = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableMissingResourceLibraryDetection);
    }

    @Override
    public boolean containsTagHandler(String ns, String localName) {
        boolean result;
        block15: {
            result = false;
            Resource ccResource = null;
            ccResource = this.getCompositeComponentResource(ns, localName);
            if (null != ccResource) {
                try (InputStream componentStream = ccResource.getInputStream();){
                    result = componentStream != null;
                }
                catch (IOException ex) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block15;
                    LOGGER.log(Level.SEVERE, ex.toString(), ex);
                }
            }
        }
        return result || super.containsTagHandler(ns, localName);
    }

    private Resource getCompositeComponentResource(String ns, String localName) {
        Resource ccResource = null;
        if (ns.equals(this.ns)) {
            FacesContext context = FacesContext.getCurrentInstance();
            String libraryName = this.getCompositeComponentLibraryName(this.ns);
            if (null != libraryName) {
                String ccName = localName + ".xhtml";
                ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
                ccResource = resourceHandler.createResource(ccName, libraryName);
            }
        }
        return ccResource;
    }

    @Override
    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        Object result = super.createTagHandler(ns, localName, tag);
        if (result == null) {
            AbstractTagLibrary.ComponentConfigWrapper componentConfig = new AbstractTagLibrary.ComponentConfigWrapper(tag, "jakarta.faces.NamingContainer", null);
            result = new CompositeComponentTagHandler(this.getCompositeComponentResource(ns, localName), componentConfig);
        }
        return result;
    }

    @Override
    public boolean tagLibraryForNSExists(String toTest) {
        boolean result = false;
        String resourceId = null;
        resourceId = this.getCompositeComponentLibraryName(toTest);
        if (null != resourceId) {
            if (this.enableMissingResourceLibraryDetection) {
                result = FacesContext.getCurrentInstance().getApplication().getResourceHandler().libraryExists(resourceId);
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Skipping call to libraryExists().  Please set context-param {0} to true to verify if library {1} actually exists", new Object[]{WebConfiguration.BooleanWebContextInitParameter.EnableMissingResourceLibraryDetection.getQualifiedName(), toTest});
                }
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean scriptComponentForResourceExists(FacesContext context, Resource componentResource) {
        boolean result = false;
        Resource scriptComponentResource = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, context.getViewRoot().getViewId()).getScriptComponentResource(context, componentResource);
        InputStream is = null;
        try {
            is = scriptComponentResource.getInputStream();
            result = null != scriptComponentResource && null != is;
        }
        catch (IOException ex) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ex.toString(), ex);
            }
        }
        finally {
            block14: {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block14;
                    LOGGER.log(Level.SEVERE, ex.toString(), ex);
                }
            }
        }
        return result;
    }

    private String getCompositeComponentLibraryName(String toTest) {
        String resourceId = null;
        if (null != this.compositeLibraryName) {
            resourceId = this.compositeLibraryName;
        } else {
            int resourceIdIndex = toTest.indexOf(NS_COMPOSITE_COMPONENT_PREFIX);
            if (-1 != resourceIdIndex && (resourceIdIndex += NS_COMPOSITE_COMPONENT_PREFIX.length()) < toTest.length()) {
                resourceId = toTest.substring(resourceIdIndex);
            }
            if (-1 != (resourceIdIndex = toTest.indexOf(XMLNS_COMPOSITE_COMPONENT_PREFIX)) && (resourceIdIndex += XMLNS_COMPOSITE_COMPONENT_PREFIX.length()) < toTest.length()) {
                resourceId = toTest.substring(resourceIdIndex);
            }
        }
        return resourceId;
    }
}

