/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.AsyncTypes;
import io.smallrye.faulttolerance.config.BulkheadConfig;
import io.smallrye.faulttolerance.config.CircuitBreakerConfig;
import io.smallrye.faulttolerance.config.FallbackConfig;
import io.smallrye.faulttolerance.config.GenericConfig;
import io.smallrye.faulttolerance.config.RetryConfig;
import io.smallrye.faulttolerance.config.TimeoutConfig;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.StringJoiner;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class FaultToleranceOperation {
    private final Class<?> beanClass;
    private final Method method;
    private final boolean async;
    private final boolean additionalAsync;
    private final boolean threadOffloadRequired;
    private final Class<?> returnType;
    private final BulkheadConfig bulkhead;
    private final CircuitBreakerConfig circuitBreaker;
    private final FallbackConfig fallback;
    private final RetryConfig retry;
    private final TimeoutConfig timeout;

    public static FaultToleranceOperation of(AnnotatedMethod<?> annotatedMethod) {
        return new FaultToleranceOperation(annotatedMethod.getDeclaringType().getJavaClass(), annotatedMethod.getJavaMember(), FaultToleranceOperation.isAsync(annotatedMethod), FaultToleranceOperation.isBlocking(annotatedMethod) || FaultToleranceOperation.isNonBlocking(annotatedMethod), FaultToleranceOperation.isThreadOffloadRequired(annotatedMethod), FaultToleranceOperation.returnType(annotatedMethod), FaultToleranceOperation.getConfig(Bulkhead.class, annotatedMethod, BulkheadConfig::new), FaultToleranceOperation.getConfig(CircuitBreaker.class, annotatedMethod, CircuitBreakerConfig::new), FaultToleranceOperation.getConfig(Fallback.class, annotatedMethod, FallbackConfig::new), FaultToleranceOperation.getConfig(Retry.class, annotatedMethod, RetryConfig::new), FaultToleranceOperation.getConfig(Timeout.class, annotatedMethod, TimeoutConfig::new));
    }

    public static FaultToleranceOperation of(Class<?> beanClass, Method method) {
        return new FaultToleranceOperation(beanClass, method, FaultToleranceOperation.isAsync(method, beanClass), FaultToleranceOperation.isBlocking(method, beanClass) || FaultToleranceOperation.isNonBlocking(method, beanClass), FaultToleranceOperation.isThreadOffloadRequired(method, beanClass), FaultToleranceOperation.returnType(method), FaultToleranceOperation.getConfig(Bulkhead.class, beanClass, method, BulkheadConfig::new), FaultToleranceOperation.getConfig(CircuitBreaker.class, beanClass, method, CircuitBreakerConfig::new), FaultToleranceOperation.getConfig(Fallback.class, beanClass, method, FallbackConfig::new), FaultToleranceOperation.getConfig(Retry.class, beanClass, method, RetryConfig::new), FaultToleranceOperation.getConfig(Timeout.class, beanClass, method, TimeoutConfig::new));
    }

    private FaultToleranceOperation(Class<?> beanClass, Method method, boolean async, boolean additionalAsync, boolean threadOffloadRequired, Class<?> returnType, BulkheadConfig bulkhead, CircuitBreakerConfig circuitBreaker, FallbackConfig fallback, RetryConfig retry, TimeoutConfig timeout) {
        this.beanClass = beanClass;
        this.method = method;
        this.async = async;
        this.additionalAsync = additionalAsync;
        this.threadOffloadRequired = threadOffloadRequired;
        this.returnType = returnType;
        this.bulkhead = bulkhead;
        this.circuitBreaker = circuitBreaker;
        this.fallback = fallback;
        this.retry = retry;
        this.timeout = timeout;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isAdditionalAsync() {
        return this.additionalAsync;
    }

    public boolean isThreadOffloadRequired() {
        return this.threadOffloadRequired;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public boolean hasBulkhead() {
        return this.bulkhead != null;
    }

    public BulkheadConfig getBulkhead() {
        return this.bulkhead;
    }

    public CircuitBreakerConfig getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public boolean hasCircuitBreaker() {
        return this.circuitBreaker != null;
    }

    public FallbackConfig getFallback() {
        return this.fallback;
    }

    public boolean hasFallback() {
        return this.fallback != null;
    }

    public RetryConfig getRetry() {
        return this.retry;
    }

    public boolean hasRetry() {
        return this.retry != null;
    }

    public TimeoutConfig getTimeout() {
        return this.timeout;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public boolean isLegitimate() {
        return this.async || this.bulkhead != null || this.circuitBreaker != null || this.fallback != null || this.retry != null || this.timeout != null;
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (FaultToleranceDefinitionException e) {
            return false;
        }
    }

    public void validate() {
        if (this.async && !this.isAcceptableAsyncReturnType(this.method.getReturnType())) {
            throw new FaultToleranceDefinitionException("Invalid @Asynchronous on " + this.method + ": must return java.util.concurrent.Future or " + FaultToleranceOperation.describeAsyncReturnTypes());
        }
        if (this.additionalAsync && !AsyncTypes.isKnown(this.method.getReturnType())) {
            throw new FaultToleranceDefinitionException("Invalid @Blocking/@NonBlocking on " + this.method + ": must return " + FaultToleranceOperation.describeAsyncReturnTypes());
        }
        if (this.bulkhead != null) {
            this.bulkhead.validate();
        }
        if (this.circuitBreaker != null) {
            this.circuitBreaker.validate();
        }
        if (this.fallback != null) {
            this.fallback.validate();
        }
        if (this.retry != null) {
            this.retry.validate();
        }
        if (this.timeout != null) {
            this.timeout.validate();
        }
    }

    private boolean isAcceptableAsyncReturnType(Class<?> returnType) {
        return Future.class.equals(returnType) || AsyncTypes.isKnown(returnType);
    }

    public String toString() {
        return "FaultToleranceOperation [beanClass=" + this.beanClass + ", method=" + this.method.toGenericString() + "]";
    }

    private static String describeAsyncReturnTypes() {
        StringJoiner result = new StringJoiner(" or ");
        for (ReactiveTypeConverter<?> converter : AsyncTypes.allKnown()) {
            result.add(converter.type().getName());
        }
        return result.toString();
    }

    private static Class<?> returnType(Method annotatedMethod) {
        return annotatedMethod.getReturnType();
    }

    private static Class<?> returnType(AnnotatedMethod<?> annotatedMethod) {
        return annotatedMethod.getJavaMember().getReturnType();
    }

    private static boolean isAsync(Method method, Class<?> beanClass) {
        return FaultToleranceOperation.getConfigStatus(Asynchronous.class, method) && FaultToleranceOperation.isAnnotated(Asynchronous.class, method, beanClass);
    }

    private static boolean isAsync(AnnotatedMethod<?> method) {
        return FaultToleranceOperation.getConfigStatus(Asynchronous.class, method.getJavaMember()) && FaultToleranceOperation.isAnnotated(Asynchronous.class, method);
    }

    private static boolean isBlocking(Method method, Class<?> beanClass) {
        return FaultToleranceOperation.getConfigStatus(Blocking.class, method) && FaultToleranceOperation.isAnnotated(Blocking.class, method, beanClass);
    }

    private static boolean isBlocking(AnnotatedMethod<?> method) {
        return FaultToleranceOperation.getConfigStatus(Blocking.class, method.getJavaMember()) && FaultToleranceOperation.isAnnotated(Blocking.class, method);
    }

    private static boolean isNonBlocking(Method method, Class<?> beanClass) {
        return FaultToleranceOperation.getConfigStatus(NonBlocking.class, method) && FaultToleranceOperation.isAnnotated(NonBlocking.class, method, beanClass);
    }

    private static boolean isNonBlocking(AnnotatedMethod<?> method) {
        return FaultToleranceOperation.getConfigStatus(NonBlocking.class, method.getJavaMember()) && FaultToleranceOperation.isAnnotated(NonBlocking.class, method);
    }

    private static <A extends Annotation, C extends GenericConfig<A>> C getConfig(Class<A> annotationType, AnnotatedMethod<?> annotatedMethod, Function<AnnotatedMethod<?>, C> function) {
        if (FaultToleranceOperation.getConfigStatus(annotationType, annotatedMethod.getJavaMember()) && FaultToleranceOperation.isAnnotated(annotationType, annotatedMethod)) {
            return (C)((GenericConfig)function.apply(annotatedMethod));
        }
        return null;
    }

    private static <A extends Annotation, C extends GenericConfig<A>> C getConfig(Class<A> annotationType, Class<?> beanClass, Method method, BiFunction<Class<?>, Method, C> function) {
        if (FaultToleranceOperation.getConfigStatus(annotationType, method) && FaultToleranceOperation.isAnnotated(annotationType, method, beanClass)) {
            return (C)((GenericConfig)function.apply(beanClass, method));
        }
        return null;
    }

    private static <A extends Annotation> boolean getConfigStatus(Class<A> annotationType, Method method) {
        boolean returnConfig;
        Config config = ConfigProvider.getConfig();
        String undefined = "undefined";
        String onMethod = config.getOptionalValue(method.getDeclaringClass().getName() + "/" + method.getName() + "/" + annotationType.getSimpleName() + "/enabled", String.class).orElse("undefined");
        String onClass = config.getOptionalValue(method.getDeclaringClass().getName() + "/" + annotationType.getSimpleName() + "/enabled", String.class).orElse("undefined");
        String onGlobal = config.getOptionalValue(annotationType.getSimpleName() + "/enabled", String.class).orElse("undefined");
        boolean bl = returnConfig = !annotationType.equals(Fallback.class) ? config.getOptionalValue("MP_Fault_Tolerance_NonFallback_Enabled", Boolean.class).orElse(true) : true;
        if (!"undefined".equals(onMethod)) {
            returnConfig = Boolean.parseBoolean(onMethod);
        } else if (!"undefined".equals(onClass)) {
            returnConfig = Boolean.parseBoolean(onClass);
        } else if (!"undefined".equals(onGlobal)) {
            returnConfig = Boolean.parseBoolean(onGlobal);
        }
        return returnConfig;
    }

    private static <A extends Annotation> boolean isAnnotated(Class<A> annotationType, AnnotatedMethod<?> annotatedMethod) {
        return annotatedMethod.isAnnotationPresent(annotationType) || annotatedMethod.getDeclaringType().isAnnotationPresent(annotationType);
    }

    private static <A extends Annotation> boolean isAnnotated(Class<A> annotationType, Method method, Class<?> beanClass) {
        if (method.isAnnotationPresent(annotationType)) {
            return true;
        }
        while (beanClass != null) {
            if (beanClass.isAnnotationPresent(annotationType)) {
                return true;
            }
            beanClass = beanClass.getSuperclass();
        }
        return false;
    }

    private static boolean isThreadOffloadRequired(AnnotatedMethod<?> method) {
        if (method.isAnnotationPresent(Blocking.class)) {
            return true;
        }
        if (method.isAnnotationPresent(NonBlocking.class)) {
            return false;
        }
        if (method.getDeclaringType().isAnnotationPresent(Blocking.class)) {
            return true;
        }
        return !method.getDeclaringType().isAnnotationPresent(NonBlocking.class);
    }

    private static boolean isThreadOffloadRequired(Method method, Class<?> beanClass) {
        if (method.isAnnotationPresent(Blocking.class)) {
            return true;
        }
        if (method.isAnnotationPresent(NonBlocking.class)) {
            return false;
        }
        while (beanClass != null) {
            if (beanClass.isAnnotationPresent(Blocking.class)) {
                return true;
            }
            if (beanClass.isAnnotationPresent(NonBlocking.class)) {
                return false;
            }
            beanClass = beanClass.getSuperclass();
        }
        return true;
    }
}

