/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Enumeration;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public final class JMSUtil {
    public static final String JMS_MESSAGE_CONSUMER = "jms_message_consumer";
    public static final String JMS_IGNORE_TIMEOUT = "jms_ignore_timeout";
    private static final char[] CORRELATTION_ID_PADDING = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

    private JMSUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message receive(Session session, Destination replyToDestination, String correlationId, long receiveTimeout, boolean pubSubNoLocal) {
        try (ResourceCloser closer = new ResourceCloser();){
            String messageSelector = correlationId == null ? null : "JMSCorrelationID = '" + correlationId + "'";
            MessageConsumer consumer = closer.register(session.createConsumer(replyToDestination, messageSelector, pubSubNoLocal));
            Message replyMessage = consumer.receive(receiveTimeout);
            if (replyMessage == null) {
                throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
            }
            Message message = replyMessage;
            return message;
        }
        catch (JMSException e) {
            throw JMSUtil.convertJmsException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message receive(Session session, Destination replyToDestination, String correlationId, long receiveTimeout, boolean pubSubNoLocal, Exchange exchange) {
        try (ResourceCloser closer = new ResourceCloser();){
            Message replyMessage;
            String messageSelector = correlationId == null ? null : "JMSCorrelationID = '" + correlationId + "'";
            MessageConsumer consumer = closer.register(session.createConsumer(replyToDestination, messageSelector, pubSubNoLocal));
            if (exchange != null) {
                exchange.put((Object)JMS_MESSAGE_CONSUMER, (Object)consumer);
            }
            if ((replyMessage = consumer.receive(receiveTimeout)) == null) {
                if ((Boolean)exchange.get((Object)JMS_IGNORE_TIMEOUT) == false) throw new JMSException("Timeout receiving message with correlationId " + correlationId);
                throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
            }
            Message message = replyMessage;
            return message;
        }
        catch (JMSException e) {
            throw JMSUtil.convertJmsException(e);
        }
    }

    public static RuntimeException convertJmsException(JMSException e) {
        return new RuntimeException(e.getMessage(), e);
    }

    public static String createCorrelationId(String prefix, long sequenceNUm) {
        String index = Long.toHexString(sequenceNUm);
        StringBuilder id = new StringBuilder(prefix);
        id.append(CORRELATTION_ID_PADDING, 0, 16 - index.length());
        id.append(index);
        return id.toString();
    }

    public static Message createAndSetPayload(Object payload, Session session, String messageType) throws JMSException {
        TextMessage message = null;
        if ("text".equals(messageType)) {
            message = session.createTextMessage((String)payload);
        } else if ("byte".equals(messageType)) {
            message = session.createBytesMessage();
            ((BytesMessage)message).writeBytes((byte[])payload);
        } else {
            message = session.createObjectMessage();
            ((ObjectMessage)message).setObject((Serializable)((byte[])payload));
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue createQueue(Connection connection, String name) throws JMSException {
        try (Session session = null;){
            session = connection.createSession(false, 1);
            Queue queue = session.createQueue(name);
            return queue;
        }
    }

    public static int getNumMessages(Connection connection, Queue queue) throws JMSException {
        Session session = connection.createSession(false, 1);
        QueueBrowser browser = session.createBrowser(queue);
        Enumeration messages = browser.getEnumeration();
        int actualNum = 0;
        while (messages.hasMoreElements()) {
            ++actualNum;
            messages.nextElement();
        }
        browser.close();
        return actualNum;
    }
}

