/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.jms.BackChannelConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.ThrottlingCounter;
import org.apache.cxf.transport.jms.util.JMSListenerContainer;
import org.apache.cxf.transport.jms.util.JMSUtil;
import org.apache.cxf.transport.jms.util.PollingMessageListenerContainer;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class JMSDestination
extends AbstractMultiplexDestination
implements MessageListener {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSDestination.class);
    private JMSConfiguration jmsConfig;
    private Bus bus;
    private JMSListenerContainer jmsListener;
    private ThrottlingCounter suspendedContinuations;
    private ClassLoader loader;
    private Connection connection;
    private boolean shutdown;

    public JMSDestination(Bus b, EndpointInfo info, JMSConfiguration jmsConfig) {
        super(b, JMSDestination.getTargetReference((EndpointInfo)info, (Bus)b), info);
        this.bus = b;
        this.jmsConfig = jmsConfig;
        info.setProperty(OneWayProcessorInterceptor.USE_ORIGINAL_THREAD, (Object)Boolean.TRUE);
        this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
        int restartLimit = jmsConfig.getMaxSuspendedContinuations() * jmsConfig.getReconnectPercentOfMax() / 100;
        this.suspendedContinuations = new ThrottlingCounter(restartLimit, jmsConfig.getMaxSuspendedContinuations());
    }

    protected Conduit getInbuiltBackChannel(org.apache.cxf.message.Message inMessage) {
        boolean robust = MessageUtils.getContextualBoolean((org.apache.cxf.message.Message)inMessage, (String)"org.apache.cxf.oneway.robust");
        if (inMessage.getExchange().isOneWay() && !robust) {
            return null;
        }
        if (this.jmsConfig.isOneSessionPerConnection()) {
            return new BackChannelConduit(inMessage, this.jmsConfig);
        }
        return new BackChannelConduit(inMessage, this.jmsConfig, this.connection);
    }

    public void activate() {
        block3: {
            this.getLogger().log(Level.FINE, "JMSDestination activate().... ");
            this.jmsConfig.ensureProperlyConfigured();
            try {
                this.jmsListener = this.createTargetDestinationListener();
            }
            catch (Exception e) {
                if (e.getCause() != null && InvalidClientIDException.class.isInstance(e.getCause())) {
                    throw e;
                }
                if (this.jmsConfig.isOneSessionPerConnection()) break block3;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JMSDestination.this.restartConnection();
                    }
                }).start();
            }
        }
    }

    private JMSListenerContainer createTargetDestinationListener() {
        PollingMessageListenerContainer pollingMessageListenerContainer;
        Session session = null;
        try {
            PollingMessageListenerContainer container;
            ExceptionListener exListener = new ExceptionListener(){
                private boolean restartTriggered;

                public synchronized void onException(JMSException exception) {
                    if (!JMSDestination.this.shutdown && !this.restartTriggered) {
                        LOG.log(Level.WARNING, "Exception on JMS connection. Trying to reconnect", exception);
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                JMSDestination.this.restartConnection();
                            }
                        }).start();
                        this.restartTriggered = true;
                    }
                }
            };
            if (!this.jmsConfig.isOneSessionPerConnection()) {
                this.connection = JMSFactory.createConnection(this.jmsConfig);
                session = this.connection.createSession(false, 1);
                Destination destination = this.jmsConfig.getTargetDestination(session);
                container = new PollingMessageListenerContainer(this.connection, destination, (MessageListener)this, exListener);
            } else {
                container = new PollingMessageListenerContainer(this.jmsConfig, false, (MessageListener)this, exListener);
            }
            container.setConcurrentConsumers(this.jmsConfig.getConcurrentConsumers());
            container.setTransactionManager(this.jmsConfig.getTransactionManager());
            container.setMessageSelector(this.jmsConfig.getMessageSelector());
            container.setTransacted(this.jmsConfig.isSessionTransacted());
            container.setDurableSubscriptionName(this.jmsConfig.getDurableSubscriptionName());
            container.setPubSubNoLocal(this.jmsConfig.isPubSubNoLocal());
            Object executor = this.bus.getProperty("org.apache.cxf.extensions.jms.destination.executor");
            if (executor instanceof Executor) {
                container.setExecutor((Executor)executor);
            }
            container.setJndiEnvironment(this.jmsConfig.getJndiEnvironment());
            container.start();
            this.suspendedContinuations.setListenerContainer(container);
            if (!this.jmsConfig.isOneSessionPerConnection()) {
                this.connection.start();
            }
            pollingMessageListenerContainer = container;
        }
        catch (JMSException e) {
            try {
                ResourceCloser.close(this.connection);
                this.connection = null;
                throw JMSUtil.convertJmsException(e);
            }
            catch (Throwable throwable) {
                ResourceCloser.close(session);
                throw throwable;
            }
        }
        ResourceCloser.close(session);
        return pollingMessageListenerContainer;
    }

    protected void restartConnection() {
        int tries = 0;
        do {
            ++tries;
            try {
                this.deactivate();
                this.jmsListener = this.createTargetDestinationListener();
                LOG.log(Level.INFO, "Established JMS connection");
            }
            catch (Exception e1) {
                this.jmsListener = null;
                String message = "Exception on reconnect. Trying again, attempt num " + tries;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.WARNING, message, e1);
                } else {
                    LOG.log(Level.WARNING, message);
                }
                try {
                    Thread.sleep(this.jmsConfig.getRetryInterval());
                }
                catch (InterruptedException e2) {
                    this.shutdown = true;
                }
            }
        } while (this.jmsListener == null && !this.shutdown);
    }

    public void deactivate() {
        if (this.jmsListener != null) {
            this.jmsListener.shutdown();
        }
        ResourceCloser.close(this.connection);
        this.suspendedContinuations.setListenerContainer(null);
        this.connection = null;
    }

    public void shutdown() {
        this.shutdown = true;
        this.getLogger().log(Level.FINE, "JMSDestination shutdown()");
        this.deactivate();
    }

    /*
     * Exception decompiling
     */
    public void onMessage(Message message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processExceptions(Exchange exchange) {
        if (!exchange.isOneWay()) {
            return;
        }
        org.apache.cxf.message.Message inMessage = exchange.getInMessage();
        if (inMessage == null) {
            return;
        }
        Exception ex = (Exception)inMessage.getContent(Exception.class);
        if (ex != null) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }
}

