/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.plugins.delegates.LinkHeaderDelegate;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.Link;
import org.jboss.resteasy.spi.LinkHeader;

public class LinkHeaders {
    private Map<String, jakarta.ws.rs.core.Link> linksByRelationship = new HashMap<String, jakarta.ws.rs.core.Link>();
    private Map<String, jakarta.ws.rs.core.Link> linksByTitle = new HashMap<String, jakarta.ws.rs.core.Link>();
    private List<jakarta.ws.rs.core.Link> links = new ArrayList<jakarta.ws.rs.core.Link>();

    public LinkHeaders addLinks(MultivaluedMap<String, String> headers) {
        List values = (List)headers.get((Object)"Link");
        if (values == null) {
            return this;
        }
        for (String val : values) {
            LinkHeader linkHeader = new LinkHeaderDelegate().fromString(val);
            for (Link link : linkHeader.getLinks()) {
                this.addLink(link.toJaxrsLink());
            }
        }
        return this;
    }

    public LinkHeaders addLinkObjects(MultivaluedMap<String, Object> headers, HeaderValueProcessor factory) {
        List values = (List)headers.get((Object)"Link");
        if (values == null) {
            return this;
        }
        for (Object val : values) {
            if (val instanceof jakarta.ws.rs.core.Link) {
                this.addLink((jakarta.ws.rs.core.Link)val);
                continue;
            }
            String str = factory.toHeaderString(val);
            this.addLink(jakarta.ws.rs.core.Link.valueOf((String)str));
        }
        return this;
    }

    public LinkHeaders addLink(jakarta.ws.rs.core.Link link) {
        this.links.add(link);
        for (String rel : link.getRels()) {
            this.linksByRelationship.put(rel, link);
        }
        if (link.getTitle() != null) {
            this.linksByTitle.put(link.getTitle(), link);
        }
        return this;
    }

    public jakarta.ws.rs.core.Link getLinkByTitle(String title) {
        return this.linksByTitle.get(title);
    }

    public jakarta.ws.rs.core.Link getLinkByRelationship(String rel) {
        return this.linksByRelationship.get(rel);
    }

    public Map<String, jakarta.ws.rs.core.Link> getLinksByRelationship() {
        return this.linksByRelationship;
    }

    public Map<String, jakarta.ws.rs.core.Link> getLinksByTitle() {
        return this.linksByTitle;
    }

    public List<jakarta.ws.rs.core.Link> getLinks() {
        return this.links;
    }
}

