/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnmodifiableMultivaluedMap<K, V>
implements MultivaluedMap<K, V> {
    private final MultivaluedMap<K, V> delegate;
    private final Set<Map.Entry<K, List<V>>> entrySet;

    public UnmodifiableMultivaluedMap(MultivaluedMap<K, V> delegate) {
        this.delegate = delegate;
        this.entrySet = this.buildEntrySet();
    }

    private Set<Map.Entry<K, List<V>>> buildEntrySet() {
        Set entrySetDelegator = this.delegate.entrySet();
        if (entrySetDelegator == null) {
            return null;
        }
        HashSet<1> entrySetToReturn = new HashSet<1>();
        for (final Map.Entry entry : entrySetDelegator) {
            entrySetToReturn.add(new Map.Entry<K, List<V>>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public List<V> getValue() {
                    List value = (List)entry.getValue();
                    return value == null ? null : Collections.unmodifiableList(value);
                }

                @Override
                public List<V> setValue(List<V> value) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return Collections.unmodifiableSet(entrySetToReturn);
    }

    public void putSingle(K k, V v) {
        throw new UnsupportedOperationException();
    }

    public void add(K k, V v) {
        throw new UnsupportedOperationException();
    }

    public V getFirst(K key) {
        return (V)this.delegate.getFirst(key);
    }

    public void addAll(K k, V ... vs) {
        throw new UnsupportedOperationException();
    }

    public void addAll(K k, List<V> list) {
        throw new UnsupportedOperationException();
    }

    public void addFirst(K k, V v) {
        throw new UnsupportedOperationException();
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<K, V> omap) {
        return this.delegate.equalsIgnoreValueOrder(omap);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.entrySet;
    }

    public List<V> get(Object key) {
        List list = (List)this.delegate.get(key);
        return list == null ? null : Collections.unmodifiableList(list);
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    public List<V> put(K key, List<V> value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends K, ? extends List<V>> m) {
        throw new UnsupportedOperationException();
    }

    public List<V> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public Collection<List<V>> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    public boolean containsKey(Object o) {
        return this.delegate.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return this.delegate.containsValue(o);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

