/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.annotations.ContentEncoding;
import org.jboss.resteasy.plugins.interceptors.encoding.GZIPEncodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.encoding.ServerContentEncodingAnnotationFilter;

@ConstrainedTo(value=RuntimeType.SERVER)
public class ServerContentEncodingAnnotationFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext configurable) {
        Class declaring = resourceInfo.getResourceClass();
        Method method = resourceInfo.getResourceMethod();
        if (declaring == null || method == null) {
            return;
        }
        Set<String> encodings = this.getEncodings(method.getAnnotations());
        if (encodings.size() <= 0 && (encodings = this.getEncodings(declaring.getAnnotations())).size() <= 0) {
            return;
        }
        if (!this.isGZipRegistered(configurable.getConfiguration())) {
            encodings.remove("gzip");
        }
        configurable.register((Object)this.createFilter(encodings));
    }

    protected boolean isGZipRegistered(Configuration configuration) {
        for (Class c : configuration.getClasses()) {
            if (!GZIPEncodingInterceptor.class.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    protected ServerContentEncodingAnnotationFilter createFilter(Set<String> encodings) {
        return new ServerContentEncodingAnnotationFilter(encodings);
    }

    protected Set<String> getEncodings(Annotation[] annotations) {
        HashSet<String> encodings = new HashSet<String>();
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(ContentEncoding.class)) continue;
            encodings.add(annotation.annotationType().getAnnotation(ContentEncoding.class).value().toLowerCase());
        }
        return encodings;
    }
}

