/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsat.client;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.util.PrivilegedMapBuilderFactory;
import com.arjuna.webservices11.util.PrivilegedServiceRegistryFactory;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsaddr.EndpointHelper;
import com.arjuna.webservices11.wsaddr.NativeEndpointReference;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsat.client.WSATClient;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.io.IOException;
import org.jboss.ws.api.addressing.MAP;
import org.jboss.ws.api.addressing.MAPBuilder;
import org.jboss.ws.api.addressing.MAPEndpoint;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;
import org.oasis_open.docs.ws_tx.wsat._2006._06.ParticipantPortType;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class ParticipantClient {
    private static final ParticipantClient CLIENT = new ParticipantClient();
    private String prepareAction = null;
    private String commitAction = null;
    private String rollbackAction = null;
    private String faultAction;
    private MAPEndpoint coordinator;
    private MAPEndpoint secureCoordinator;

    public ParticipantClient() {
        MAPBuilder builder = PrivilegedMapBuilderFactory.getInstance().getBuilderInstance();
        this.prepareAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Prepare";
        this.commitAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Commit";
        this.rollbackAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Rollback";
        this.faultAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/fault";
        ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
        String coordinatorURIString = serviceRegistry.getServiceURI("CoordinatorService", false);
        String secureCoordinatorURIString = serviceRegistry.getServiceURI("CoordinatorService", true);
        this.coordinator = builder.newEndpoint(coordinatorURIString);
        this.secureCoordinator = builder.newEndpoint(secureCoordinatorURIString);
    }

    public void sendPrepare(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFromFaultTo(map, coordinator, identifier);
        ParticipantPortType port = this.getPort(endpoint, map, this.prepareAction);
        Notification prepare = new Notification();
        port.prepareOperation(prepare);
    }

    public void sendCommit(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFromFaultTo(map, coordinator, identifier);
        ParticipantPortType port = this.getPort(endpoint, map, this.commitAction);
        Notification commit = new Notification();
        port.commitOperation(commit);
    }

    public void sendRollback(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFromFaultTo(map, coordinator, identifier);
        ParticipantPortType port = this.getPort(endpoint, map, this.rollbackAction);
        Notification rollback = new Notification();
        port.rollbackOperation(rollback);
    }

    public void sendSoapFault(MAP map, SoapFault soapFault, InstanceIdentifier identifier) throws SoapFault, IOException {
        ParticipantPortType port = this.getPort(null, map, this.faultAction);
        soapFault.setAction(this.faultAction);
        Fault fault = ((SoapFault11)soapFault).toFault();
        port.soapFault(fault);
    }

    MAPEndpoint getCoordinator(W3CEndpointReference endpoint, MAP map) {
        String address;
        if (endpoint != null) {
            NativeEndpointReference nativeRef = EndpointHelper.transform(NativeEndpointReference.class, (EndpointReference)endpoint);
            address = nativeRef.getAddress();
        } else {
            address = map.getTo();
        }
        if (address.startsWith("https")) {
            return this.secureCoordinator;
        }
        return this.coordinator;
    }

    public static ParticipantClient getClient() {
        return CLIENT;
    }

    private ParticipantPortType getPort(W3CEndpointReference participant, MAP map, String action) {
        AddressingHelper.installNoneReplyTo(map);
        if (participant != null) {
            return WSATClient.getParticipantPort(participant, action, map);
        }
        return WSATClient.getParticipantPort(action, map);
    }
}

