/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.criteria.JoinType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.exception.NotAuditedException;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.EntityInstantiator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.AuditAssociationQuery;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.impl.AuditAssociationQueryImpl;
import org.hibernate.envers.query.internal.impl.AuditQueryImplementor;
import org.hibernate.envers.query.order.AuditOrder;
import org.hibernate.envers.query.projection.AuditProjection;
import org.hibernate.envers.tools.Pair;
import org.hibernate.query.Query;

public abstract class AbstractAuditQuery
implements AuditQueryImplementor {
    protected EntityInstantiator entityInstantiator;
    protected List<AuditCriterion> criterions;
    protected String entityName;
    protected String entityClassName;
    protected String versionsEntityName;
    protected QueryBuilder qb;
    protected final Map<String, String> aliasToEntityNameMap = new HashMap<String, String>();
    protected boolean hasOrder;
    protected final EnversService enversService;
    protected final AuditReaderImplementor versionsReader;
    protected final List<AuditAssociationQueryImpl<?>> associationQueries = new ArrayList();
    protected final Map<String, AuditAssociationQueryImpl<AuditQueryImplementor>> associationQueryMap = new HashMap<String, AuditAssociationQueryImpl<AuditQueryImplementor>>();
    protected final List<Pair<String, AuditProjection>> projections = new ArrayList<Pair<String, AuditProjection>>();
    private Integer maxResults;
    private Integer firstResult;
    private Boolean cacheable;
    private String cacheRegion;
    private String comment;
    private FlushMode flushMode;
    private CacheMode cacheMode;
    private Integer timeout;
    private LockOptions lockOptions = new LockOptions(LockMode.NONE);

    protected AbstractAuditQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls) {
        this(enversService, versionsReader, cls, cls.getName());
    }

    protected AbstractAuditQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, String entityName) {
        this.enversService = enversService;
        this.versionsReader = versionsReader;
        this.criterions = new ArrayList<AuditCriterion>();
        this.entityInstantiator = new EntityInstantiator(enversService, versionsReader);
        this.entityClassName = cls.getName();
        this.entityName = entityName;
        this.versionsEntityName = enversService.getAuditEntitiesConfiguration().getAuditEntityName(entityName);
        if (!enversService.getEntitiesConfigurations().isVersioned(entityName)) {
            throw new NotAuditedException(entityName, "Entity [" + entityName + "] is not versioned");
        }
        this.aliasToEntityNameMap.put("e__", entityName);
        this.qb = new QueryBuilder(this.versionsEntityName, "e__");
    }

    @Override
    public String getAlias() {
        return "e__";
    }

    protected Query buildQuery() {
        Query query = this.qb.toQuery(this.versionsReader.getSession());
        this.setQueryProperties(query);
        return query;
    }

    protected List buildAndExecuteQuery() {
        Query query = this.buildQuery();
        return query.list();
    }

    public abstract List list() throws AuditException;

    @Override
    public List getResultList() throws AuditException {
        return this.list();
    }

    @Override
    public Object getSingleResult() throws AuditException, NonUniqueResultException, NoResultException {
        List result = this.list();
        if (result == null || result.size() == 0) {
            throw new NoResultException();
        }
        if (result.size() > 1) {
            throw new NonUniqueResultException();
        }
        return result.get(0);
    }

    @Override
    public AuditQuery add(AuditCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    @Override
    public AuditQuery addProjection(AuditProjection projection) {
        AuditProjection.ProjectionData projectionData = projection.getData(this.enversService);
        String projectionEntityAlias = projectionData.getAlias("e__");
        String projectionEntityName = this.aliasToEntityNameMap.get(projectionEntityAlias);
        this.registerProjection(projectionEntityName, projection);
        String propertyName = CriteriaTools.determinePropertyName(this.enversService, this.versionsReader, projectionEntityName, projectionData.getPropertyName());
        this.qb.addProjection(projectionData.getFunction(), projectionEntityAlias, propertyName, projectionData.isDistinct());
        return this;
    }

    @Override
    public void registerProjection(String entityName, AuditProjection projection) {
        this.projections.add(Pair.make(entityName, projection));
    }

    protected boolean hasProjection() {
        return !this.projections.isEmpty();
    }

    @Override
    public AuditQuery addOrder(AuditOrder order) {
        this.hasOrder = true;
        AuditOrder.OrderData orderData = order.getData(this.enversService);
        String orderEntityAlias = orderData.getAlias("e__");
        String orderEntityName = this.aliasToEntityNameMap.get(orderEntityAlias);
        String propertyName = CriteriaTools.determinePropertyName(this.enversService, this.versionsReader, orderEntityName, orderData.getPropertyName());
        this.qb.addOrder(orderEntityAlias, propertyName, orderData.isAscending());
        return this;
    }

    @Override
    public AuditAssociationQuery<? extends AuditQuery> traverseRelation(String associationName, JoinType joinType) {
        return this.traverseRelation(associationName, joinType, null);
    }

    @Override
    public AuditAssociationQuery<? extends AuditQuery> traverseRelation(String associationName, JoinType joinType, String alias) {
        AuditAssociationQueryImpl<AuditQueryImplementor> result = this.associationQueryMap.get(associationName);
        if (result == null) {
            result = new AuditAssociationQueryImpl<AbstractAuditQuery>(this.enversService, this.versionsReader, this, this.qb, associationName, joinType, this.aliasToEntityNameMap, "e__", alias);
            this.associationQueries.add(result);
            this.associationQueryMap.put(associationName, result);
        }
        return result;
    }

    @Override
    public AuditQuery setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public AuditQuery setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public AuditQuery setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    @Override
    public AuditQuery setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return this;
    }

    @Override
    public AuditQuery setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public AuditQuery setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    @Override
    public AuditQuery setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public AuditQuery setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    @Deprecated
    public AuditQuery setLockMode(LockMode lockMode) {
        this.lockOptions.setLockMode(lockMode);
        return this;
    }

    public AuditQuery setLockOptions(LockOptions lockOptions) {
        LockOptions.copy((LockOptions)lockOptions, (LockOptions)this.lockOptions);
        return this;
    }

    protected void setQueryProperties(Query query) {
        if (this.maxResults != null) {
            query.setMaxResults(this.maxResults.intValue());
        }
        if (this.firstResult != null) {
            query.setFirstResult(this.firstResult.intValue());
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.comment != null) {
            query.setComment(this.comment);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        if (this.cacheMode != null) {
            query.setCacheMode(this.cacheMode);
        }
        if (this.timeout != null) {
            query.setTimeout(this.timeout.intValue());
        }
        if (this.lockOptions != null && this.lockOptions.getLockMode() != LockMode.NONE) {
            query.setLockMode("e__", this.lockOptions.getLockMode());
        }
    }

    protected List applyProjections(List queryResult, Number revision) {
        ArrayList<Object> result = new ArrayList<Object>(queryResult.size());
        if (this.hasProjection()) {
            for (Object qr : queryResult) {
                if (this.projections.size() == 1) {
                    Pair<String, AuditProjection> projection = this.projections.get(0);
                    result.add(projection.getSecond().convertQueryResult(this.enversService, this.entityInstantiator, projection.getFirst(), revision, qr));
                    continue;
                }
                Object[] qresults = (Object[])qr;
                Object[] tresults = new Object[qresults.length];
                for (int i = 0; i < qresults.length; ++i) {
                    Pair<String, AuditProjection> projection = this.projections.get(i);
                    tresults[i] = projection.getSecond().convertQueryResult(this.enversService, this.entityInstantiator, projection.getFirst(), revision, qresults[i]);
                }
                result.add(tresults);
            }
        } else {
            this.entityInstantiator.addInstancesFromVersionsEntities(this.entityName, result, queryResult, revision);
        }
        return result;
    }

    protected EntityConfiguration getEntityConfiguration() {
        return this.enversService.getEntitiesConfigurations().get(this.entityName);
    }

    protected String getEntityName() {
        return this.entityName;
    }
}

