/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.faulttolerance.deployment;

import io.smallrye.faulttolerance.FaultToleranceExtension;
import jakarta.enterprise.inject.spi.Extension;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.wildfly.extension.microprofile.faulttolerance.deployment.MicroProfileFaultToleranceMarker;

public class MicroProfileFaultToleranceDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        WeldCapability weldCapability;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!MicroProfileFaultToleranceMarker.isMarked(deploymentUnit)) {
            return;
        }
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        try {
            weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw new IllegalStateException();
        }
        weldCapability.registerExtensionInstance((Extension)new FaultToleranceExtension(), deploymentUnit);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

