/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.security.auth.message.module.ClientAuthModule;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.message.config.JBossClientAuthConfig;

public class JBossClientAuthContext
implements ClientAuthContext {
    private JBossClientAuthConfig config;

    public JBossClientAuthContext(JBossClientAuthConfig config) {
        if (config == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("config");
        }
        this.config = config;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        Iterator iter = this.config.getClientAuthModules().iterator();
        while (iter.hasNext()) {
            ((ClientAuthModule)iter.next()).cleanSubject(messageInfo, subject);
        }
    }

    public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
        Iterator iter = this.config.getClientAuthModules().iterator();
        AuthStatus status = null;
        while (iter.hasNext() && (status = ((ClientAuthModule)iter.next()).secureRequest(messageInfo, clientSubject)) != AuthStatus.FAILURE) {
        }
        return status;
    }

    public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        Iterator iter = this.config.getClientAuthModules().iterator();
        AuthStatus status = null;
        while (iter.hasNext() && (status = ((ClientAuthModule)iter.next()).validateResponse(messageInfo, clientSubject, serviceSubject)) != AuthStatus.FAILURE) {
        }
        return status;
    }
}

