/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.james.mime4j.field.ContentDispositionField;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.parser.Field;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInputImpl;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;

public class MultipartFormDataInputImpl
extends MultipartInputImpl
implements MultipartFormDataInput {
    protected Map<String, InputPart> formData = new HashMap<String, InputPart>();
    protected Map<String, List<InputPart>> formDataMap = new HashMap<String, List<InputPart>>();

    public MultipartFormDataInputImpl(MediaType contentType, Providers workers) {
        super(contentType, workers);
    }

    @Override
    @Deprecated
    public Map<String, InputPart> getFormData() {
        return this.formData;
    }

    @Override
    public Map<String, List<InputPart>> getFormDataMap() {
        return this.formDataMap;
    }

    @Override
    public <T> T getFormDataPart(String key, Class<T> rawType, Type genericType) throws IOException {
        List<InputPart> list = this.getFormDataMap().get(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        InputPart part = list.get(0);
        if (part == null) {
            return null;
        }
        return part.getBody(rawType, genericType);
    }

    @Override
    public <T> T getFormDataPart(String key, GenericType<T> type) throws IOException {
        List<InputPart> list = this.getFormDataMap().get(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        InputPart part = list.get(0);
        if (part == null) {
            return null;
        }
        return part.getBody(type);
    }

    @Override
    protected InputPart extractPart(BodyPart bodyPart) throws IOException {
        List<InputPart> list;
        InputPart currPart = super.extractPart(bodyPart);
        Field disposition = bodyPart.getHeader().getField("Content-Disposition");
        if (disposition == null) {
            throw new RuntimeException(Messages.MESSAGES.couldFindNoContentDispositionHeader());
        }
        if (disposition instanceof ContentDispositionField) {
            String name = ((ContentDispositionField)disposition).getParameter("name");
            list = this.formDataMap.get(name);
            if (list == null) {
                list = new LinkedList<InputPart>();
                this.formData.put(name, currPart);
                this.formDataMap.put(name, list);
            }
        } else {
            throw new RuntimeException(Messages.MESSAGES.couldNotParseContentDisposition(disposition));
        }
        list.add(currPart);
        return currPart;
    }

    @Override
    protected void finalize() throws Throwable {
        this.close();
    }
}

