/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.yaml.i18n.LogMessages;
import org.jboss.resteasy.plugins.providers.yaml.i18n.Messages;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.WriterException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;

@Provider
@Consumes(value={"text/yaml", "text/x-yaml", "application/x-yaml"})
@Produces(value={"text/yaml", "text/x-yaml", "application/x-yaml"})
@Deprecated
public class YamlProvider
extends AbstractEntityProvider<Object> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", ((Object)((Object)this)).getClass().getName());
            if (this.isValidInternalType(type)) {
                return new Yaml().load(entityStream);
            }
            CustomClassLoaderConstructor customClassLoaderConstructor = new CustomClassLoaderConstructor(type.getClassLoader());
            return new Yaml((BaseConstructor)customClassLoaderConstructor).loadAs(entityStream, type);
        }
        catch (Exception e) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.failedToDecodeYamlMessage(e.getMessage()));
            throw new ReaderException(Messages.MESSAGES.failedToDecodeYaml(), (Throwable)e);
        }
    }

    protected boolean isValidInternalType(Class type) {
        return List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || type.isArray();
    }

    protected boolean isValidType(Class type) {
        if (this.isValidInternalType(type)) {
            return true;
        }
        if (StreamingOutput.class.isAssignableFrom(type)) {
            return false;
        }
        String className = type.getName();
        if (className.startsWith("java.")) {
            return false;
        }
        if (className.startsWith("javax.")) {
            return false;
        }
        return !type.isPrimitive();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isValidType(type);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", ((Object)((Object)this)).getClass().getName());
            entityStream.write(new Yaml().dump(t).getBytes());
        }
        catch (Exception e) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.failedToEncodeYaml(t.toString()));
            throw new WriterException((Throwable)e);
        }
    }
}

