/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import jakarta.ejb.EJBAccessException;
import jakarta.security.jacc.PolicyContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.ejb3.security.SecurityContextInterceptorHolder;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.security.SecurityRolesAssociation;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecurityContextInterceptor
implements Interceptor {
    private final PrivilegedAction<Void> pushAction;
    private final PrivilegedAction<Void> popAction;
    private final String policyContextID;

    public SecurityContextInterceptor(final SecurityContextInterceptorHolder holder) {
        this.pushAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                holder.securityManager.push(holder.securityDomain);
                try {
                    if (!holder.skipAuthentication) {
                        holder.securityManager.authenticate(holder.runAs, holder.runAsPrincipal, holder.extraRoles);
                    }
                    if (holder.principalVsRolesMap != null) {
                        SecurityRolesAssociation.setSecurityRoles(holder.principalVsRolesMap);
                    }
                }
                catch (Throwable t) {
                    if (holder.principalVsRolesMap != null) {
                        SecurityRolesAssociation.setSecurityRoles(null);
                    }
                    holder.securityManager.pop();
                    if (t instanceof SecurityException) {
                        throw new EJBAccessException(t.getMessage());
                    }
                    throw t;
                }
                return null;
            }
        };
        this.popAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (holder.principalVsRolesMap != null) {
                    SecurityRolesAssociation.setSecurityRoles(null);
                }
                holder.securityManager.pop();
                return null;
            }
        };
        this.policyContextID = holder.policyContextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        String previousContextID = this.setContextID(this.policyContextID);
        if (WildFlySecurityManager.isChecking()) {
            AccessController.doPrivileged(this.pushAction);
        } else {
            this.pushAction.run();
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            this.setContextID(previousContextID);
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(this.popAction);
            } else {
                this.popAction.run();
            }
        }
    }

    protected String setContextID(String contextID) {
        if (!WildFlySecurityManager.isChecking()) {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)contextID);
            return previousID;
        }
        SetContextIDAction action = new SetContextIDAction(contextID);
        return AccessController.doPrivileged(action);
    }

    private static class SetContextIDAction
    implements PrivilegedAction<String> {
        private String contextID;

        SetContextIDAction(String contextID) {
            this.contextID = contextID;
        }

        @Override
        public String run() {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return previousID;
        }
    }
}

