/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.el.cache;

import jakarta.el.ELException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanPropertiesCache {
    private static final SoftConcurrentHashMap properties = new SoftConcurrentHashMap();

    public static Method getMethod(Class<?> cl, Method method) {
        if (method == null) {
            return null;
        }
        if (Modifier.isPublic(cl.getModifiers())) {
            return method;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c = interfaces[i];
            Method m = null;
            try {
                m = c.getMethod(method.getName(), method.getParameterTypes());
                c = m.getDeclaringClass();
                m = BeanPropertiesCache.getMethod(c, m);
                if (m == null) continue;
                return m;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> c = cl.getSuperclass();
        if (c != null) {
            Method m = null;
            try {
                m = c.getMethod(method.getName(), method.getParameterTypes());
                c = m.getDeclaringClass();
                m = BeanPropertiesCache.getMethod(c, m);
                if (m != null) {
                    return m;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static SoftConcurrentHashMap getProperties() {
        return properties;
    }

    static void clear(ClassLoader classLoader) {
        properties.clear(classLoader);
    }

    public static final class BeanProperties {
        private final Map<String, BeanProperty> propertyMap = new HashMap<String, BeanProperty>();

        public BeanProperties(Class<?> baseClass) {
            PropertyDescriptor[] descriptors;
            try {
                BeanInfo info = Introspector.getBeanInfo(baseClass);
                descriptors = info.getPropertyDescriptors();
            }
            catch (IntrospectionException ie) {
                throw new ELException(ie);
            }
            for (PropertyDescriptor pd : descriptors) {
                this.propertyMap.put(pd.getName(), new BeanProperty(baseClass, pd));
            }
        }

        public BeanProperty getBeanProperty(String property) {
            return this.propertyMap.get(property);
        }
    }

    public static final class BeanProperty {
        private Method readMethod;
        private Method writeMethod;
        private PropertyDescriptor descriptor;

        public BeanProperty(Class<?> baseClass, PropertyDescriptor descriptor) {
            this.descriptor = descriptor;
            this.readMethod = BeanPropertiesCache.getMethod(baseClass, descriptor.getReadMethod());
            this.writeMethod = BeanPropertiesCache.getMethod(baseClass, descriptor.getWriteMethod());
        }

        public Class getPropertyType() {
            return this.descriptor.getPropertyType();
        }

        public boolean isReadOnly() {
            return this.getWriteMethod() == null;
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }
    }

    public static class SoftConcurrentHashMap
    extends ConcurrentHashMap<Class<?>, BeanProperties> {
        private static final int CACHE_INIT_SIZE = 1024;
        private ConcurrentHashMap<Class<?>, BPSoftReference> map = new ConcurrentHashMap(1024);
        private ReferenceQueue<BeanProperties> refQ = new ReferenceQueue();

        private void cleanup() {
            BPSoftReference BPRef = null;
            while ((BPRef = (BPSoftReference)this.refQ.poll()) != null) {
                this.map.remove(BPRef.key);
            }
        }

        protected void clear(ClassLoader classLoader) {
            Iterator<Map.Entry<Class<?>, BPSoftReference>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Class<?>, BPSoftReference> entry = it.next();
                if (entry.getKey().getClassLoader() != classLoader) continue;
                it.remove();
            }
        }

        @Override
        public BeanProperties put(Class<?> key, BeanProperties value) {
            this.cleanup();
            BPSoftReference prev = this.map.put(key, new BPSoftReference(key, value, this.refQ));
            return prev == null ? null : (BeanProperties)prev.get();
        }

        @Override
        public BeanProperties putIfAbsent(Class<?> key, BeanProperties value) {
            this.cleanup();
            BPSoftReference prev = this.map.putIfAbsent(key, new BPSoftReference(key, value, this.refQ));
            return prev == null ? null : (BeanProperties)prev.get();
        }

        @Override
        public BeanProperties get(Object key) {
            this.cleanup();
            BPSoftReference BPRef = this.map.get(key);
            if (BPRef == null) {
                return null;
            }
            if (BPRef.get() == null) {
                this.map.remove(key);
                return null;
            }
            return (BeanProperties)BPRef.get();
        }
    }

    private static class BPSoftReference
    extends SoftReference<BeanProperties> {
        final Class<?> key;

        BPSoftReference(Class<?> key, BeanProperties beanProperties, ReferenceQueue<BeanProperties> refQ) {
            super(beanProperties, refQ);
            this.key = key;
        }
    }
}

