/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.WebApplicationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ConstructorParameter;
import org.jboss.resteasy.spi.metadata.ResourceConstructor;

public class ConstructorInjectorImpl
implements ConstructorInjector {
    protected Constructor constructor;
    protected ValueInjector[] params;

    public ConstructorInjectorImpl(ResourceConstructor constructor, ResteasyProviderFactory factory) {
        this.constructor = constructor.getConstructor();
        this.params = new ValueInjector[constructor.getParams().length];
        int i = 0;
        for (ConstructorParameter parameter : constructor.getParams()) {
            this.params[i++] = factory.getInjectorFactory().createParameterExtractor(parameter, factory);
        }
    }

    public ConstructorInjectorImpl(Constructor constructor, ResteasyProviderFactory factory) {
        this.constructor = constructor;
        this.params = new ValueInjector[constructor.getParameterTypes().length];
        Parameter[] reflectionParameters = constructor.getParameters();
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            Class<?> type = constructor.getParameterTypes()[i];
            Type genericType = constructor.getGenericParameterTypes()[i];
            Annotation[] annotations = constructor.getParameterAnnotations()[i];
            String name = reflectionParameters[i].getName();
            this.params[i] = factory.getInjectorFactory().createParameterExtractor(constructor.getDeclaringClass(), (AccessibleObject)constructor, name, type, genericType, annotations, factory);
        }
    }

    @Override
    public Object[] injectableArguments(HttpRequest input, HttpResponse response) {
        Object[] args = null;
        if (this.params != null && this.params.length > 0) {
            args = new Object[this.params.length];
            int i = 0;
            for (ValueInjector extractor : this.params) {
                args[i++] = extractor.inject(input, response);
            }
        }
        return args;
    }

    @Override
    public Object[] injectableArguments() {
        Object[] args = null;
        if (this.params != null && this.params.length > 0) {
            args = new Object[this.params.length];
            int i = 0;
            for (ValueInjector extractor : this.params) {
                args[i++] = extractor.inject();
            }
        }
        return args;
    }

    @Override
    public Object construct(HttpRequest request, HttpResponse httpResponse) throws Failure, ApplicationException, WebApplicationException {
        Object[] args = null;
        try {
            args = this.injectableArguments(request, httpResponse);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(Messages.MESSAGES.failedProcessingArguments(this.constructor.toString()), e);
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new InternalServerErrorException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), e);
        }
        catch (IllegalAccessException e) {
            throw new InternalServerErrorException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            throw new ApplicationException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), e.getCause());
        }
        catch (IllegalArgumentException e) {
            String msg = Messages.MESSAGES.badArguments(this.constructor.toString() + "  (");
            boolean first = false;
            for (Object arg : args) {
                if (!first) {
                    first = true;
                } else {
                    msg = msg + ",";
                }
                msg = arg == null ? msg + " null" : msg + " " + arg;
            }
            throw new InternalServerErrorException(msg, e);
        }
    }

    @Override
    public Object construct() {
        Object[] args = null;
        args = this.injectableArguments();
        try {
            return this.constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(Messages.MESSAGES.failedToConstruct(this.constructor.toString()), e.getCause());
        }
        catch (IllegalArgumentException e) {
            String msg = Messages.MESSAGES.badArguments(this.constructor.toString() + "  (");
            boolean first = false;
            for (Object arg : args) {
                if (!first) {
                    first = true;
                } else {
                    msg = msg + ",";
                }
                msg = arg == null ? msg + " null" : msg + " " + arg;
            }
            throw new RuntimeException(msg, e);
        }
    }
}

