/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.qourum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QuorumVoteMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QuorumVoteReplyMessage;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.cluster.qourum.Quorum;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVote;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVoteHandler;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVoteServerConnect;
import org.apache.activemq.artemis.core.server.cluster.qourum.Vote;

public final class QuorumManager
implements ClusterTopologyListener,
ActiveMQComponent {
    private final ExecutorService executor;
    private final ClusterController clusterController;
    private final Map<String, Quorum> quorums = new HashMap<String, Quorum>();
    private final Map<QuorumVote, VoteRunnableHolder> voteRunnables = new HashMap<QuorumVote, VoteRunnableHolder>();
    private final Map<SimpleString, QuorumVoteHandler> handlers = new HashMap<SimpleString, QuorumVoteHandler>();
    private boolean started = false;
    private int maxClusterSize = 0;

    public QuorumManager(ExecutorService threadPool, ClusterController clusterController) {
        this.clusterController = clusterController;
        this.executor = threadPool;
    }

    public void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        Map<QuorumVote, VoteRunnableHolder> map = this.voteRunnables;
        synchronized (map) {
            this.started = false;
            for (VoteRunnableHolder voteRunnableHolder : this.voteRunnables.values()) {
                for (VoteRunnable runnable : voteRunnableHolder.runnables) {
                    runnable.close();
                }
            }
        }
        for (Quorum quorum : this.quorums.values()) {
            quorum.close();
        }
        this.quorums.clear();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void registerQuorum(Quorum quorum) {
        this.quorums.put(quorum.getName(), quorum);
        quorum.setQuorumManager(this);
    }

    public void unRegisterQuorum(Quorum quorum) {
        this.quorums.remove(quorum.getName());
    }

    public void nodeUP(TopologyMember topologyMember, boolean last) {
        int newClusterSize = this.clusterController.getDefaultClusterSize();
        this.maxClusterSize = newClusterSize > this.maxClusterSize ? newClusterSize : this.maxClusterSize;
        for (Quorum quorum : this.quorums.values()) {
            quorum.nodeUp(this.clusterController.getDefaultClusterTopology());
        }
    }

    public void nodeDown(long eventUID, String nodeID) {
        for (Quorum quorum : this.quorums.values()) {
            quorum.nodeDown(this.clusterController.getDefaultClusterTopology(), eventUID, nodeID);
        }
    }

    public boolean hasLive(String nodeID, int quorumSize, int voteTimeout, TimeUnit voteTimeoutUnit) {
        Objects.requireNonNull(nodeID, "nodeID");
        if (!this.started) {
            throw new IllegalStateException("QuorumManager must start first");
        }
        int size = quorumSize == -1 ? this.maxClusterSize : quorumSize;
        QuorumVoteServerConnect quorumVote = new QuorumVoteServerConnect(size, nodeID);
        boolean noLive = this.awaitVoteComplete(quorumVote, voteTimeout, voteTimeoutUnit);
        return !noLive;
    }

    public boolean isStillLive(String nodeID, TransportConfiguration liveConnector, int quorumSize, int voteTimeout, TimeUnit voteTimeoutUnit) {
        Objects.requireNonNull(nodeID, "nodeID");
        Objects.requireNonNull(liveConnector, "liveConnector");
        if (!this.started) {
            throw new IllegalStateException("QuorumManager must start first");
        }
        int size = quorumSize == -1 ? this.maxClusterSize : quorumSize;
        QuorumVoteServerConnect quorumVote = new QuorumVoteServerConnect(size, nodeID, true, liveConnector.toString());
        return this.awaitVoteComplete(quorumVote, voteTimeout, voteTimeoutUnit);
    }

    private boolean awaitVoteComplete(QuorumVoteServerConnect quorumVote, int voteTimeout, TimeUnit voteTimeoutUnit) {
        int maxClusterSize = this.maxClusterSize;
        this.vote(quorumVote);
        if (maxClusterSize > 1) {
            try {
                quorumVote.await(voteTimeout, voteTimeoutUnit);
            }
            catch (InterruptedException interruption) {
                ActiveMQServerLogger.LOGGER.quorumVoteAwaitInterrupted();
            }
        } else {
            ActiveMQServerLogger.LOGGER.ignoringQuorumVote(maxClusterSize);
        }
        this.voteComplete(quorumVote);
        return quorumVote.getDecision();
    }

    public int getMaxClusterSize() {
        return this.maxClusterSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vote(QuorumVote quorumVote) {
        ArrayList<VoteRunnable> runnables = new ArrayList<VoteRunnable>();
        Map<QuorumVote, VoteRunnableHolder> map = this.voteRunnables;
        synchronized (map) {
            if (!this.started) {
                return;
            }
            ActiveMQServerLogger.LOGGER.initiatingQuorumVote(quorumVote.getName());
            for (TopologyMemberImpl tm : this.clusterController.getDefaultClusterTopology().getMembers()) {
                if (tm.getNodeId().equals(this.clusterController.getNodeID().toString())) continue;
                Pair pair = tm.getConnector();
                TransportConfiguration serverTC = (TransportConfiguration)pair.getA();
                VoteRunnable voteRunnable = new VoteRunnable(serverTC, quorumVote);
                runnables.add(voteRunnable);
            }
            int votes = runnables.size();
            ActiveMQServerLogger.LOGGER.requestedQuorumVotes(votes);
            if (votes > 0) {
                this.voteRunnables.put(quorumVote, new VoteRunnableHolder(quorumVote, runnables, votes));
                for (VoteRunnable runnable : runnables) {
                    this.executor.submit(runnable);
                }
            } else {
                quorumVote.allVotesCast(this.clusterController.getDefaultClusterTopology());
            }
        }
    }

    private Vote vote(SimpleString handler, Vote vote) {
        QuorumVoteHandler quorumVoteHandler = this.handlers.get(handler);
        return quorumVoteHandler.vote(vote);
    }

    private void voteComplete(QuorumVoteServerConnect quorumVote) {
        VoteRunnableHolder holder = this.voteRunnables.remove(quorumVote);
        if (holder != null) {
            for (VoteRunnable runnable : holder.runnables) {
                runnable.close();
            }
        }
    }

    public void registerQuorumHandler(QuorumVoteHandler quorumVoteHandler) {
        this.handlers.put(quorumVoteHandler.getQuorumName(), quorumVoteHandler);
    }

    public String toString() {
        return QuorumManager.class.getSimpleName() + "(server=" + this.clusterController.getIdentity() + ")";
    }

    private QuorumVoteHandler getVoteHandler(SimpleString handler) {
        return this.handlers.get(handler);
    }

    public void handleQuorumVote(Channel clusterChannel, Packet packet) {
        QuorumVoteMessage quorumVoteMessage = (QuorumVoteMessage)packet;
        QuorumVoteHandler voteHandler = this.getVoteHandler(quorumVoteMessage.getHandler());
        if (voteHandler == null) {
            ActiveMQServerLogger.LOGGER.noVoteHandlerConfigured();
            return;
        }
        quorumVoteMessage.decode(voteHandler);
        ActiveMQServerLogger.LOGGER.receivedQuorumVoteRequest(quorumVoteMessage.getVote().toString());
        Vote vote = this.vote(quorumVoteMessage.getHandler(), quorumVoteMessage.getVote());
        ActiveMQServerLogger.LOGGER.sendingQuorumVoteResponse(vote.toString());
        clusterChannel.send((Packet)new QuorumVoteReplyMessage(quorumVoteMessage.getHandler(), vote));
    }

    private Vote sendQuorumVote(ClusterControl clusterControl, SimpleString handler, Vote vote) {
        try {
            ClientSessionFactoryInternal sessionFactory = clusterControl.getSessionFactory();
            String remoteAddress = sessionFactory.getConnection().getRemoteAddress();
            ActiveMQServerLogger.LOGGER.sendingQuorumVoteRequest(remoteAddress, vote.toString());
            QuorumVoteReplyMessage replyMessage = (QuorumVoteReplyMessage)clusterControl.getClusterChannel().get().sendBlocking((Packet)new QuorumVoteMessage(handler, vote), (byte)-3);
            QuorumVoteHandler voteHandler = this.getVoteHandler(replyMessage.getHandler());
            replyMessage.decodeRest(voteHandler);
            Vote voteResponse = replyMessage.getVote();
            ActiveMQServerLogger.LOGGER.receivedQuorumVoteResponse(remoteAddress, voteResponse.toString());
            return voteResponse;
        }
        catch (ActiveMQException e) {
            return null;
        }
    }

    private void votingComplete(QuorumVote quorumVote) {
        VoteRunnableHolder voteRunnableHolder = this.voteRunnables.get(quorumVote);
        if (voteRunnableHolder != null) {
            voteRunnableHolder.voteComplete();
        }
    }

    private final class VoteRunnable
    implements Runnable {
        private final TransportConfiguration serverTC;
        private final QuorumVote quorumVote;
        private ClusterControl clusterControl;

        private VoteRunnable(TransportConfiguration serverTC, QuorumVote quorumVote) {
            this.serverTC = serverTC;
            this.quorumVote = quorumVote;
        }

        @Override
        public void run() {
            try {
                if (!QuorumManager.this.started) {
                    return;
                }
                this.clusterControl = QuorumManager.this.clusterController.connectToNode(this.serverTC);
                this.clusterControl.authorize();
                Vote vote = this.quorumVote.connected();
                if (vote.isRequestServerVote()) {
                    vote = QuorumManager.this.sendQuorumVote(this.clusterControl, this.quorumVote.getName(), vote);
                    this.quorumVote.vote(vote);
                } else {
                    this.quorumVote.vote(vote);
                }
            }
            catch (Exception e) {
                Vote vote = this.quorumVote.notConnected();
                this.quorumVote.vote(vote);
            }
            finally {
                try {
                    if (this.clusterControl != null) {
                        this.clusterControl.close();
                    }
                }
                catch (Exception exception) {}
                QuorumManager.this.votingComplete(this.quorumVote);
            }
        }

        public void close() {
            if (this.clusterControl != null) {
                this.clusterControl.close();
            }
        }
    }

    private final class VoteRunnableHolder {
        private final QuorumVote quorumVote;
        private final List<VoteRunnable> runnables;
        private int size;

        private VoteRunnableHolder(QuorumVote quorumVote, List<VoteRunnable> runnables, int size) {
            this.quorumVote = quorumVote;
            this.runnables = runnables;
            this.size = size;
        }

        public synchronized void voteComplete() {
            --this.size;
            if (this.size <= 0) {
                this.quorumVote.allVotesCast(QuorumManager.this.clusterController.getDefaultClusterTopology());
            }
        }
    }
}

