/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.collections.LinkedListImpl;
import org.jboss.logging.Logger;

public class PagedReferenceImpl
extends LinkedListImpl.Node<PagedReferenceImpl>
implements PagedReference,
Runnable {
    private static final Logger logger = Logger.getLogger(PagedReferenceImpl.class);
    private static final AtomicIntegerFieldUpdater<PagedReferenceImpl> DELIVERY_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PagedReferenceImpl.class, "deliveryCount");
    private final PagePosition position;
    private WeakReference<PagedMessage> message;
    private static final long UNDEFINED_DELIVERY_TIME = Long.MIN_VALUE;
    private long deliveryTime = Long.MIN_VALUE;
    private int persistedCount;
    private int messageEstimate = -1;
    private long consumerID;
    private boolean hasConsumerID = false;
    private volatile int deliveryCount = 0;
    private final PageSubscription subscription;
    private boolean alreadyAcked;
    private Object protocolData;
    private static final byte IS_NOT_LARGE_MESSAGE = 0;
    private static final byte IS_LARGE_MESSAGE = 1;
    private static final byte UNDEFINED_IS_LARGE_MESSAGE = 2;
    private byte largeMessage;
    private long transactionID = -2L;
    private long messageID = -1L;
    private long messageSize = -1L;
    private Consumer<? super MessageReference> onDelivery;
    private static final byte IS_NOT_DURABLE = 0;
    private static final byte IS_DURABLE = 1;
    private static final byte UNDEFINED_IS_DURABLE = -1;
    private byte durable = (byte)-1;

    @Override
    public Object getProtocolData() {
        return this.protocolData;
    }

    @Override
    public void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
    }

    @Override
    public Message getMessage() {
        return this.getPagedMessage().getMessage();
    }

    @Override
    public void onDelivery(Consumer<? super MessageReference> onDelivery) {
        this.onDelivery = onDelivery;
    }

    @Override
    public void run() {
        Consumer<? super MessageReference> onDelivery = this.onDelivery;
        if (onDelivery != null) {
            try {
                onDelivery.accept(this);
            }
            finally {
                this.onDelivery = null;
            }
        }
    }

    @Override
    public synchronized PagedMessage getPagedMessage() {
        PagedMessage returnMessage;
        PagedMessage pagedMessage = returnMessage = this.message != null ? (PagedMessage)this.message.get() : null;
        if (returnMessage == null) {
            returnMessage = this.subscription.queryMessage(this.position);
            this.message = new WeakReference<PagedMessage>(returnMessage);
        }
        return returnMessage;
    }

    @Override
    public PagePosition getPosition() {
        return this.position;
    }

    public PagedReferenceImpl(PagePosition position, PagedMessage message, PageSubscription subscription) {
        this.position = position;
        this.message = new WeakReference<PagedMessage>(message);
        this.subscription = subscription;
        if (message != null) {
            this.largeMessage = message.getMessage().isLargeMessage() ? (byte)1 : 0;
            this.transactionID = message.getTransactionID();
            this.messageID = message.getMessage().getMessageID();
            this.durable = message.getMessage().isDurable() ? (byte)1 : 0;
            this.deliveryTime = message.getMessage().getScheduledDeliveryTime();
            this.getPersistentSize();
        } else {
            this.largeMessage = (byte)2;
            this.transactionID = -2L;
            this.messageID = -1L;
            this.messageSize = -1L;
            this.durable = (byte)-1;
            this.deliveryTime = Long.MIN_VALUE;
        }
    }

    @Override
    public boolean isPaged() {
        return true;
    }

    @Override
    public void setPersistedCount(int count) {
        this.persistedCount = count;
    }

    @Override
    public int getPersistedCount() {
        return this.persistedCount;
    }

    @Override
    public int getMessageMemoryEstimate() {
        if (this.messageEstimate <= 0) {
            try {
                this.messageEstimate = this.getMessage().getMemoryEstimate();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorCalculateMessageMemoryEstimate(e);
            }
        }
        return this.messageEstimate;
    }

    @Override
    public MessageReference copy(Queue queue) {
        return new PagedReferenceImpl(this.position, this.getPagedMessage(), this.subscription);
    }

    @Override
    public long getScheduledDeliveryTime() {
        if (this.deliveryTime == Long.MIN_VALUE) {
            try {
                Message msg = this.getMessage();
                return msg.getScheduledDeliveryTime();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorCalculateScheduledDeliveryTime(e);
                return 0L;
            }
        }
        return this.deliveryTime;
    }

    @Override
    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        assert (scheduledDeliveryTime != Long.MIN_VALUE) : "can't use a reserved value";
        this.deliveryTime = scheduledDeliveryTime;
    }

    @Override
    public int getDeliveryCount() {
        return DELIVERY_COUNT_UPDATER.get(this);
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        DELIVERY_COUNT_UPDATER.set(this, deliveryCount);
    }

    @Override
    public void incrementDeliveryCount() {
        DELIVERY_COUNT_UPDATER.incrementAndGet(this);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("++deliveryCount = " + this.deliveryCount + " for " + this), (Throwable)new Exception("trace"));
        }
    }

    @Override
    public void decrementDeliveryCount() {
        DELIVERY_COUNT_UPDATER.decrementAndGet(this);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("--deliveryCount = " + this.deliveryCount + " for " + this), (Throwable)new Exception("trace"));
        }
    }

    @Override
    public Queue getQueue() {
        return this.subscription.getQueue();
    }

    @Override
    public void handled() {
        this.getQueue().referenceHandled(this);
    }

    @Override
    public void setInDelivery(boolean inDelivery) {
    }

    @Override
    public boolean isInDelivery() {
        return false;
    }

    @Override
    public void setAlreadyAcked() {
        this.alreadyAcked = true;
    }

    @Override
    public boolean isAlreadyAcked() {
        return this.alreadyAcked;
    }

    @Override
    public void acknowledge() throws Exception {
        this.subscription.ack(this);
    }

    @Override
    public void acknowledge(Transaction tx) throws Exception {
        this.acknowledge(tx, null);
    }

    @Override
    public void acknowledge(Transaction tx, ServerConsumer consumer) throws Exception {
        this.acknowledge(tx, AckReason.NORMAL, consumer);
    }

    @Override
    public void acknowledge(Transaction tx, AckReason reason, ServerConsumer consumer) throws Exception {
        if (tx == null) {
            this.getQueue().acknowledge(this, reason, consumer);
        } else {
            this.getQueue().acknowledge(tx, this, reason, consumer);
        }
    }

    public String toString() {
        String msgToString;
        try {
            msgToString = this.getPagedMessage().toString();
        }
        catch (Throwable e) {
            msgToString = "error:" + e.getMessage();
        }
        return "PagedReferenceImpl [position=" + this.position + ", message=" + msgToString + ", deliveryTime=" + (this.deliveryTime == Long.MIN_VALUE ? null : Long.valueOf(this.deliveryTime)) + ", persistedCount=" + this.persistedCount + ", deliveryCount=" + this.deliveryCount + ", subscription=" + this.subscription + "]";
    }

    @Override
    public void emptyConsumerID() {
        this.hasConsumerID = false;
    }

    @Override
    public void setConsumerId(long consumerID) {
        this.hasConsumerID = true;
        this.consumerID = consumerID;
    }

    @Override
    public boolean hasConsumerId() {
        return this.hasConsumerID;
    }

    @Override
    public long getConsumerId() {
        if (!this.hasConsumerID) {
            throw new IllegalStateException("consumerID isn't specified: please check hasConsumerId first");
        }
        return this.consumerID;
    }

    @Override
    public boolean isLargeMessage() {
        if (this.largeMessage == 2 && this.message != null) {
            this.initializeIsLargeMessage();
        }
        return this.largeMessage == 1;
    }

    private void initializeIsLargeMessage() {
        assert (this.largeMessage == 2 && this.message != null);
        this.largeMessage = this.getMessage().isLargeMessage() ? (byte)1 : 0;
    }

    @Override
    public long getTransactionID() {
        if (this.transactionID < -1L) {
            this.transactionID = this.getPagedMessage().getTransactionID();
        }
        return this.transactionID;
    }

    @Override
    public void addPendingFlag() {
        this.subscription.addPendingDelivery(this.position);
    }

    @Override
    public void removePendingFlag() {
        this.subscription.removePendingDelivery(this.position);
    }

    @Override
    public long getMessageID() {
        if (this.messageID < 0L) {
            this.messageID = this.getPagedMessage().getMessage().getMessageID();
        }
        return this.messageID;
    }

    @Override
    public SimpleString getLastValueProperty() {
        SimpleString lastValue = this.getMessage().getSimpleStringProperty(this.getQueue().getLastValueKey());
        if (lastValue == null) {
            lastValue = this.getMessage().getLastValueProperty();
        }
        return lastValue;
    }

    @Override
    public long getPersistentSize() {
        if (this.messageSize == -1L) {
            try {
                this.messageSize = this.getPagedMessage().getPersistentSize();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorCalculatePersistentSize(e);
            }
        }
        return this.messageSize;
    }

    @Override
    public PagingStore getOwner() {
        return null;
    }

    @Override
    public void setOwner(PagingStore owner) {
    }

    @Override
    public boolean isDurable() {
        if (this.durable == -1) {
            this.durable = this.getMessage().isDurable() ? (byte)1 : 0;
        }
        return this.durable == 1;
    }
}

