/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import jakarta.json.JsonObjectBuilder;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ConnectionFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.StringUtil;

public class ConnectionView
extends ActiveMQAbstractView<RemotingConnection> {
    private static final String defaultSortColumn = "connectionID";
    private final ActiveMQServer server;

    public ConnectionView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new ConnectionFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return RemotingConnection.class;
    }

    @Override
    public JsonObjectBuilder toJson(RemotingConnection connection) {
        List<ServerSession> sessions = this.server.getSessions(connection.getID().toString());
        TreeSet<String> users = new TreeSet<String>();
        String jmsSessionClientID = null;
        for (ServerSession session : sessions) {
            String username = session.getUsername() == null ? "" : session.getUsername();
            users.add(username);
            if (session.getMetaData("jms-session") == null) continue;
            jmsSessionClientID = session.getMetaData("jms-client-id");
        }
        return JsonLoader.createObjectBuilder().add(defaultSortColumn, this.toString(connection.getID())).add("remoteAddress", this.toString(connection.getRemoteAddress())).add("users", StringUtil.joinStringList(users, (String)",")).add("creationTime", new Date(connection.getCreationTime()).toString()).add("implementation", this.toString(connection.getClass().getSimpleName())).add("protocol", this.toString(connection.getProtocolName())).add("clientID", this.toString(connection.getClientID() != null ? connection.getClientID() : jmsSessionClientID)).add("localAddress", this.toString(connection.getTransportLocalAddress())).add("sessionCount", sessions.size());
    }

    @Override
    public Object getField(RemotingConnection connection, String fieldName) {
        switch (fieldName) {
            case "connectionID": {
                return connection.getID();
            }
            case "remoteAddress": {
                return connection.getRemoteAddress();
            }
            case "users": {
                TreeSet<String> users = new TreeSet<String>();
                List<ServerSession> sessions = this.server.getSessions(connection.getID().toString());
                for (ServerSession session : sessions) {
                    String username = session.getUsername() == null ? "" : session.getUsername();
                    users.add(username);
                }
                return StringUtil.joinStringList(users, (String)",");
            }
            case "creationTime": {
                return new Date(connection.getCreationTime());
            }
            case "implementation": {
                return connection.getClass().getSimpleName();
            }
            case "protocol": {
                return connection.getProtocolName();
            }
            case "clientID": {
                return connection.getClientID();
            }
            case "localAddress": {
                return connection.getTransportLocalAddress();
            }
            case "sessionCount": {
                return this.server.getSessions(connection.getID().toString()).size();
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

