/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.smallrye.metrics.MetricRegistries;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.ComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.impl.MetricsCollector;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={MetricsCollector.class})
@Scope(value=Scopes.GLOBAL)
public final class MetricsCollectorFactory
implements ComponentFactory,
AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(MetricsCollectorFactory.class);
    @Inject
    GlobalConfiguration globalConfig;

    @Override
    public Object construct(String componentName) {
        if (this.globalConfig.metrics().enabled()) {
            try {
                ConfigProvider.getConfig();
                MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
                return new MetricsCollector(registry);
            }
            catch (Throwable e) {
                log.debug("Microprofile metrics are not available due to missing classpath dependencies.", e);
            }
        }
        return null;
    }
}

