/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;

public class KeyInfoGeneratorManager {
    private final Map<Class<? extends Credential>, KeyInfoGeneratorFactory> factories = new HashMap<Class<? extends Credential>, KeyInfoGeneratorFactory>(5);

    public void registerFactory(@Nonnull KeyInfoGeneratorFactory factory) {
        this.factories.put(factory.getCredentialType(), factory);
    }

    public void deregisterFactory(@Nonnull KeyInfoGeneratorFactory factory) {
        this.factories.remove(factory.getCredentialType());
    }

    @Nonnull
    public Collection<KeyInfoGeneratorFactory> getFactories() {
        return Collections.unmodifiableCollection(this.factories.values());
    }

    @Nullable
    public KeyInfoGeneratorFactory getFactory(@Nonnull Credential credential) {
        Constraint.isNotNull((Object)credential, (String)"Credential cannot be null");
        return this.factories.get(credential.getCredentialType());
    }
}

