/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import jakarta.transaction.Synchronization;
import org.infinispan.hibernate.cache.commons.access.NonTxPutFromLoadInterceptor;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;

public class InvalidationSynchronization
implements Synchronization {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(InvalidationSynchronization.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Object lockOwner;
    private final NonTxPutFromLoadInterceptor nonTxPutFromLoadInterceptor;
    private final Object key;

    public InvalidationSynchronization(NonTxPutFromLoadInterceptor nonTxPutFromLoadInterceptor, Object key, Object lockOwner) {
        assert (lockOwner != null);
        this.nonTxPutFromLoadInterceptor = nonTxPutFromLoadInterceptor;
        this.key = key;
        this.lockOwner = lockOwner;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        if (trace) {
            log.tracef("After completion callback with status %d", status);
        }
        this.nonTxPutFromLoadInterceptor.endInvalidating(this.key, this.lockOwner, status == 3 || status == 8);
    }
}

