/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.RamUsageEstimator;

public class CachedOrdinalsReader
extends OrdinalsReader
implements Accountable {
    private final OrdinalsReader source;
    private final Map<Object, CachedOrds> ordsCache = new WeakHashMap<Object, CachedOrds>();

    public CachedOrdinalsReader(OrdinalsReader source) {
        this.source = source;
    }

    private synchronized CachedOrds getCachedOrds(LeafReaderContext context) throws IOException {
        Object cacheKey = context.reader().getCoreCacheKey();
        CachedOrds ords = this.ordsCache.get(cacheKey);
        if (ords == null) {
            ords = new CachedOrds(this.source.getReader(context), context.reader().maxDoc());
            this.ordsCache.put(cacheKey, ords);
        }
        return ords;
    }

    @Override
    public String getIndexFieldName() {
        return this.source.getIndexFieldName();
    }

    @Override
    public OrdinalsReader.OrdinalsSegmentReader getReader(LeafReaderContext context) throws IOException {
        final CachedOrds cachedOrds = this.getCachedOrds(context);
        return new OrdinalsReader.OrdinalsSegmentReader(){

            @Override
            public void get(int docID, IntsRef ordinals) {
                ordinals.ints = cachedOrds.ordinals;
                ordinals.offset = cachedOrds.offsets[docID];
                ordinals.length = cachedOrds.offsets[docID + 1] - ordinals.offset;
            }
        };
    }

    public synchronized long ramBytesUsed() {
        long bytes = 0L;
        for (CachedOrds ords : this.ordsCache.values()) {
            bytes += ords.ramBytesUsed();
        }
        return bytes;
    }

    public synchronized Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables((String)"segment", this.ordsCache);
    }

    public static final class CachedOrds
    implements Accountable {
        public final int[] offsets;
        public final int[] ordinals;

        public CachedOrds(OrdinalsReader.OrdinalsSegmentReader source, int maxDoc) throws IOException {
            this.offsets = new int[maxDoc + 1];
            int[] ords = new int[maxDoc];
            long totOrds = 0L;
            IntsRef values = new IntsRef(32);
            for (int docID = 0; docID < maxDoc; ++docID) {
                this.offsets[docID] = (int)totOrds;
                source.get(docID, values);
                long nextLength = totOrds + (long)values.length;
                if (nextLength > (long)ords.length) {
                    if (nextLength > (long)ArrayUtil.MAX_ARRAY_LENGTH) {
                        throw new IllegalStateException("too many ordinals (>= " + nextLength + ") to cache");
                    }
                    ords = ArrayUtil.grow((int[])ords, (int)((int)nextLength));
                }
                System.arraycopy(values.ints, 0, ords, (int)totOrds, values.length);
                totOrds = nextLength;
            }
            this.offsets[maxDoc] = (int)totOrds;
            if ((double)totOrds / (double)ords.length < 0.9) {
                this.ordinals = new int[(int)totOrds];
                System.arraycopy(ords, 0, this.ordinals, 0, (int)totOrds);
            } else {
                this.ordinals = ords;
            }
        }

        public long ramBytesUsed() {
            long mem = RamUsageEstimator.shallowSizeOf((Object)this) + RamUsageEstimator.sizeOf((int[])this.offsets);
            if (this.offsets != this.ordinals) {
                mem += RamUsageEstimator.sizeOf((int[])this.ordinals);
            }
            return mem;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }
}

