/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.tracerresolver;

import jakarta.annotation.Priority;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

final class PriorityComparator
implements Comparator<Object> {
    private static final int UNDEFINED_PRIORITY = Integer.MAX_VALUE;
    private static final boolean PRIORITY_AVAILABLE = PriorityComparator.isPriorityAnnotationAvailable();
    private static final PriorityComparator INSTANCE = new PriorityComparator();

    private PriorityComparator() {
    }

    static <T> Iterable<T> prioritize(Iterable<T> iterable) {
        if (!PRIORITY_AVAILABLE) {
            return iterable;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T value : iterable) {
            list.add(value);
        }
        Collections.sort(list, INSTANCE);
        return list;
    }

    @Override
    public int compare(Object value1, Object value2) {
        return PriorityComparator.comparePriority(PriorityComparator.priorityOf(value1), PriorityComparator.priorityOf(value2));
    }

    private static int comparePriority(int prio1, int prio2) {
        return prio1 == prio2 ? 0 : (prio1 < 0 ? (prio2 < 0 ? PriorityComparator.comparePriority(Math.abs(prio1), Math.abs(prio2)) : 1) : (prio2 < 0 ? -1 : (prio1 < prio2 ? -1 : 1)));
    }

    private static int priorityOf(Object value) {
        if (value == null) {
            return Integer.MAX_VALUE;
        }
        Class<?> type = value instanceof Class ? (Class<?>)value : value.getClass();
        Priority priority = type.getAnnotation(Priority.class);
        return priority != null ? priority.value() : PriorityComparator.priorityOf(type.getSuperclass());
    }

    private static boolean isPriorityAnnotationAvailable() {
        try {
            return Class.forName("jakarta.annotation.Priority") != null;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (LinkageError le) {
            return false;
        }
    }
}

