/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.io.File;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.resources.ServerConfigResource;
import org.jboss.as.host.controller.resources.ServerConfigResourceDefinition;
import org.jboss.dmr.ModelNode;

public class ServerAddHandler
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfo hostControllerInfo;
    private final ServerInventory serverInventory;
    private final ControlledProcessState processState;
    private final File domainDataDir;

    private ServerAddHandler(LocalHostControllerInfo hostControllerInfo, ServerInventory serverInventory, ControlledProcessState processState, File domainDataDir) {
        super(ServerConfigResourceDefinition.SERVER_CONFIG_CAPABILITY, ServerConfigResourceDefinition.WRITABLE_ATTRIBUTES);
        this.hostControllerInfo = hostControllerInfo;
        this.serverInventory = serverInventory;
        this.processState = processState;
        this.domainDataDir = domainDataDir;
    }

    public static ServerAddHandler create(LocalHostControllerInfo hostControllerInfo, ServerInventory serverInventory, ControlledProcessState processState, File domainDataDir) {
        return new ServerAddHandler(hostControllerInfo, serverInventory, processState, domainDataDir);
    }

    protected Resource createResource(OperationContext context) {
        ServerConfigResource serverConfigResource = new ServerConfigResource(this.serverInventory, this.processState, context.getCurrentAddress().getLastElement().getValue(), this.domainDataDir, Resource.Factory.create());
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)serverConfigResource);
        return serverConfigResource;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        PathAddress address = context.getCurrentAddress();
        PathAddress running = address.subAddress(0, 1).append(new PathElement[]{PathElement.pathElement((String)"server", (String)address.getLastElement().getValue())});
        ModelNode runningServerAdd = new ModelNode();
        runningServerAdd.get("operation").set(OPERATION_NAME);
        runningServerAdd.get("address").set(running.toModelNode());
        context.addStep(runningServerAdd, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)PlaceholderResource.INSTANCE);
            }
        }, OperationContext.Stage.MODEL, true);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }
}

