/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.js;

import io.undertow.js.InjectionProvider;
import io.undertow.js.UndertowJS;
import io.undertow.js.UndertowScriptLogger;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.FileUtils;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.ServiceLoader;

public class UndertowJSServletExtension
implements ServletExtension {
    private final String SCRIPTS_FILE = "WEB-INF/undertow-scripts.conf";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        try {
            ResourceManager resourceManager = deploymentInfo.getResourceManager();
            if (resourceManager == null) {
                return;
            }
            Resource scripts = resourceManager.getResource("WEB-INF/undertow-scripts.conf");
            if (scripts == null) {
                return;
            }
            try (InputStream data = scripts.getUrl().openStream();){
                String[] lines;
                UndertowJS.Builder builder = UndertowJS.builder();
                ArrayList<String> files = new ArrayList<String>();
                String contents = FileUtils.readFile((InputStream)data);
                for (String line : lines = contents.split("\n")) {
                    String trimmed = line;
                    int commentIndex = trimmed.indexOf("#");
                    if (commentIndex > -1) {
                        trimmed = trimmed.substring(0, commentIndex);
                    }
                    if ((trimmed = trimmed.trim()).isEmpty()) continue;
                    Resource path = resourceManager.getResource(trimmed);
                    if (path != null) {
                        files.add(trimmed);
                        continue;
                    }
                    throw UndertowScriptLogger.ROOT_LOGGER.couldNotFileScript(trimmed);
                }
                builder.addResources(resourceManager, files);
                ClassLoader classLoader = deploymentInfo.getClassLoader() != null ? deploymentInfo.getClassLoader() : this.getClass().getClassLoader();
                ServiceLoader<InjectionProvider> loader = ServiceLoader.load(InjectionProvider.class, classLoader);
                for (InjectionProvider provider : loader) {
                    builder.addInjectionProvider(provider);
                }
                builder.addHandlerWrapper(new HandlerWrapper(){

                    public HttpHandler wrap(final HttpHandler handler) {
                        return new HttpHandler(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void handleRequest(HttpServerExchange exchange) throws Exception {
                                ServletRequestContext current = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ServletRequestContext>(){

                                    @Override
                                    public ServletRequestContext run() {
                                        return ServletRequestContext.current();
                                    }
                                }) : ServletRequestContext.current();
                                if (current == null) {
                                    ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                                    if (src != null) {
                                        ThreadSetupAction.Handle handle = src.getDeployment().getThreadSetupAction().setup(exchange);
                                        try {
                                            handler.handleRequest(exchange);
                                        }
                                        finally {
                                            handle.tearDown();
                                        }
                                    } else {
                                        handler.handleRequest(exchange);
                                    }
                                } else {
                                    handler.handleRequest(exchange);
                                }
                            }
                        };
                    }
                });
                builder.setHotDeployment(true);
                builder.setClassLoader(classLoader);
                builder.setResourceManager(resourceManager);
                UndertowJS js = builder.build();
                js.start();
                deploymentInfo.addInnerHandlerChainWrapper(js.getHandlerWrapper());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

